/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.util;

import io.reactivesocket.Payload;
import io.reactivesocket.ReactiveSocket;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class ReactiveSocketProxy
implements ReactiveSocket {
    protected final ReactiveSocket child;
    private final Function<Subscriber<? super Payload>, Subscriber<? super Payload>> subscriberWrapper;

    public ReactiveSocketProxy(ReactiveSocket child, Function<Subscriber<? super Payload>, Subscriber<? super Payload>> subscriberWrapper) {
        this.child = child;
        this.subscriberWrapper = subscriberWrapper;
    }

    public ReactiveSocketProxy(ReactiveSocket child) {
        this(child, null);
    }

    @Override
    public Publisher<Void> fireAndForget(Payload payload) {
        return this.child.fireAndForget(payload);
    }

    @Override
    public Publisher<Payload> requestResponse(Payload payload) {
        if (this.subscriberWrapper == null) {
            return this.child.requestResponse(payload);
        }
        return s -> {
            Subscriber<? super Payload> subscriber = this.subscriberWrapper.apply((Subscriber<? super Payload>)s);
            this.child.requestResponse(payload).subscribe(subscriber);
        };
    }

    @Override
    public Publisher<Payload> requestStream(Payload payload) {
        if (this.subscriberWrapper == null) {
            return this.child.requestStream(payload);
        }
        return s -> {
            Subscriber<? super Payload> subscriber = this.subscriberWrapper.apply((Subscriber<? super Payload>)s);
            this.child.requestStream(payload).subscribe(subscriber);
        };
    }

    @Override
    public Publisher<Payload> requestSubscription(Payload payload) {
        if (this.subscriberWrapper == null) {
            return this.child.requestSubscription(payload);
        }
        return s -> {
            Subscriber<? super Payload> subscriber = this.subscriberWrapper.apply((Subscriber<? super Payload>)s);
            this.child.requestSubscription(payload).subscribe(subscriber);
        };
    }

    @Override
    public Publisher<Payload> requestChannel(Publisher<Payload> payloads) {
        if (this.subscriberWrapper == null) {
            return this.child.requestChannel(payloads);
        }
        return s -> {
            Subscriber<? super Payload> subscriber = this.subscriberWrapper.apply((Subscriber<? super Payload>)s);
            this.child.requestChannel(payloads).subscribe(subscriber);
        };
    }

    @Override
    public Publisher<Void> metadataPush(Payload payload) {
        return this.child.metadataPush(payload);
    }

    @Override
    public double availability() {
        return this.child.availability();
    }

    @Override
    public Publisher<Void> close() {
        return this.child.close();
    }

    @Override
    public Publisher<Void> onClose() {
        return this.child.onClose();
    }

    public String toString() {
        return "ReactiveSocketProxy(" + this.child + ')';
    }
}

