/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.util;

import io.reactivesocket.AbstractReactiveSocket;
import io.reactivesocket.Payload;
import io.reactivesocket.ReactiveSocket;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class ReactiveSocketDecorator {
    private Function<Payload, Publisher<Payload>> reqResp;
    private Function<Payload, Publisher<Payload>> reqStream;
    private Function<Payload, Publisher<Payload>> reqSub;
    private Function<Publisher<Payload>, Publisher<Payload>> reqChannel;
    private Function<Payload, Publisher<Void>> fnf;
    private Function<Payload, Publisher<Void>> metaPush;
    private Supplier<Double> availability;
    private Supplier<Publisher<Void>> close;
    private Supplier<Publisher<Void>> onClose;
    private final ReactiveSocket delegate;

    private ReactiveSocketDecorator(ReactiveSocket delegate) {
        this.delegate = delegate;
        this.reqResp = payload -> delegate.requestResponse((Payload)payload);
        this.reqStream = payload -> delegate.requestStream((Payload)payload);
        this.reqSub = payload -> delegate.requestSubscription((Payload)payload);
        this.reqChannel = payload -> delegate.requestChannel((Publisher<Payload>)payload);
        this.fnf = payload -> delegate.fireAndForget((Payload)payload);
        this.metaPush = payload -> delegate.metadataPush((Payload)payload);
        this.availability = () -> delegate.availability();
        this.close = () -> delegate.close();
        this.onClose = () -> delegate.onClose();
    }

    public ReactiveSocket finish() {
        return new ReactiveSocket(){

            @Override
            public Publisher<Void> fireAndForget(Payload payload) {
                return (Publisher)ReactiveSocketDecorator.this.fnf.apply(payload);
            }

            @Override
            public Publisher<Payload> requestResponse(Payload payload) {
                return (Publisher)ReactiveSocketDecorator.this.reqResp.apply(payload);
            }

            @Override
            public Publisher<Payload> requestStream(Payload payload) {
                return (Publisher)ReactiveSocketDecorator.this.reqStream.apply(payload);
            }

            @Override
            public Publisher<Payload> requestSubscription(Payload payload) {
                return (Publisher)ReactiveSocketDecorator.this.reqSub.apply(payload);
            }

            @Override
            public Publisher<Payload> requestChannel(Publisher<Payload> payloads) {
                return (Publisher)ReactiveSocketDecorator.this.reqChannel.apply(payloads);
            }

            @Override
            public Publisher<Void> metadataPush(Payload payload) {
                return (Publisher)ReactiveSocketDecorator.this.metaPush.apply(payload);
            }

            @Override
            public Publisher<Void> close() {
                return (Publisher)ReactiveSocketDecorator.this.close.get();
            }

            @Override
            public Publisher<Void> onClose() {
                return (Publisher)ReactiveSocketDecorator.this.onClose.get();
            }

            @Override
            public double availability() {
                return (Double)ReactiveSocketDecorator.this.availability.get();
            }
        };
    }

    public ReactiveSocketDecorator requestResponse(Function<Publisher<Payload>, Publisher<Payload>> responseMapper) {
        this.reqResp = payload -> (Publisher)responseMapper.apply(this.delegate.requestResponse((Payload)payload));
        return this;
    }

    public ReactiveSocketDecorator requestResponse(BiFunction<Payload, ReactiveSocket, Publisher<Payload>> mapper) {
        this.reqResp = payload -> (Publisher)mapper.apply((Payload)payload, this.delegate);
        return this;
    }

    public ReactiveSocketDecorator requestStream(Function<Publisher<Payload>, Publisher<Payload>> responseMapper) {
        this.reqStream = payload -> (Publisher)responseMapper.apply(this.delegate.requestStream((Payload)payload));
        return this;
    }

    public ReactiveSocketDecorator requestStream(BiFunction<Payload, ReactiveSocket, Publisher<Payload>> mapper) {
        this.reqStream = payload -> (Publisher)mapper.apply((Payload)payload, this.delegate);
        return this;
    }

    public ReactiveSocketDecorator requestSubscription(Function<Publisher<Payload>, Publisher<Payload>> responseMapper) {
        this.reqSub = payload -> (Publisher)responseMapper.apply(this.delegate.requestSubscription((Payload)payload));
        return this;
    }

    public ReactiveSocketDecorator requestSubscription(BiFunction<Payload, ReactiveSocket, Publisher<Payload>> mapper) {
        this.reqSub = payload -> (Publisher)mapper.apply((Payload)payload, this.delegate);
        return this;
    }

    public ReactiveSocketDecorator requestChannel(Function<Publisher<Payload>, Publisher<Payload>> responseMapper) {
        this.reqChannel = payload -> (Publisher)responseMapper.apply(this.delegate.requestChannel((Publisher<Payload>)payload));
        return this;
    }

    public ReactiveSocketDecorator requestChannel(BiFunction<Publisher<Payload>, ReactiveSocket, Publisher<Payload>> mapper) {
        this.reqChannel = payloads -> (Publisher)mapper.apply((Publisher<Payload>)payloads, this.delegate);
        return this;
    }

    public ReactiveSocketDecorator fireAndForget(Function<Publisher<Void>, Publisher<Void>> responseMapper) {
        this.fnf = payload -> (Publisher)responseMapper.apply(this.delegate.fireAndForget((Payload)payload));
        return this;
    }

    public ReactiveSocketDecorator fireAndForget(BiFunction<Payload, ReactiveSocket, Publisher<Void>> mapper) {
        this.fnf = payloads -> (Publisher)mapper.apply((Payload)payloads, this.delegate);
        return this;
    }

    public ReactiveSocketDecorator metadataPush(Function<Publisher<Void>, Publisher<Void>> responseMapper) {
        this.metaPush = payload -> (Publisher)responseMapper.apply(this.delegate.metadataPush((Payload)payload));
        return this;
    }

    public ReactiveSocketDecorator metadataPush(BiFunction<Payload, ReactiveSocket, Publisher<Void>> mapper) {
        this.metaPush = payloads -> (Publisher)mapper.apply((Payload)payloads, this.delegate);
        return this;
    }

    public ReactiveSocketDecorator decorateAllResponses(Function<Publisher<Payload>, Publisher<Payload>> mapper) {
        this.requestResponse((Publisher<Payload> resp) -> (Publisher)mapper.apply((Publisher<Payload>)resp)).requestStream((Publisher<Payload> resp) -> (Publisher)mapper.apply((Publisher<Payload>)resp)).requestSubscription((Publisher<Payload> resp) -> (Publisher)mapper.apply((Publisher<Payload>)resp)).requestChannel((Publisher<Payload> resp) -> (Publisher)mapper.apply((Publisher<Payload>)resp));
        return this;
    }

    public ReactiveSocketDecorator decorateAllVoidResponses(Function<Publisher<Void>, Publisher<Void>> mapper) {
        this.fireAndForget((Publisher<Void> resp) -> (Publisher)mapper.apply((Publisher<Void>)resp)).metadataPush((Publisher<Void> resp) -> (Publisher)mapper.apply((Publisher<Void>)resp));
        return this;
    }

    public ReactiveSocketDecorator close(Function<ReactiveSocket, Publisher<Void>> mapper) {
        this.close = () -> (Publisher)mapper.apply(this.delegate);
        return this;
    }

    public ReactiveSocketDecorator onClose(Function<ReactiveSocket, Publisher<Void>> mapper) {
        this.onClose = () -> (Publisher)mapper.apply(this.delegate);
        return this;
    }

    public ReactiveSocketDecorator availability(Function<ReactiveSocket, Double> mapper) {
        this.availability = () -> (Double)mapper.apply(this.delegate);
        return this;
    }

    public static ReactiveSocketDecorator wrap(ReactiveSocket source) {
        return new ReactiveSocketDecorator(source);
    }

    public static ReactiveSocketDecorator empty() {
        return new ReactiveSocketDecorator(new AbstractReactiveSocket(){});
    }
}

