/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.util;

import io.reactivesocket.Frame;
import io.reactivesocket.Payload;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class PayloadImpl
implements Payload {
    public static final Payload EMPTY = new PayloadImpl(Frame.NULL_BYTEBUFFER, Frame.NULL_BYTEBUFFER);
    private final ByteBuffer data;
    private final int dataStartPosition;
    private final int metadataStartPosition;
    private final boolean reusable;
    private final ByteBuffer metadata;

    public PayloadImpl(String data) {
        this(data, (String)null);
    }

    public PayloadImpl(String data, String metadata) {
        this(PayloadImpl.fromString(data), PayloadImpl.fromString(metadata));
    }

    public PayloadImpl(String data, Charset charset) {
        this(PayloadImpl.fromString(data, charset), PayloadImpl.fromString(null));
    }

    public PayloadImpl(String data, Charset dataCharset, String metadata, Charset metaDataCharset) {
        this(PayloadImpl.fromString(data, dataCharset), PayloadImpl.fromString(metadata, metaDataCharset));
    }

    public PayloadImpl(byte[] data) {
        this(ByteBuffer.wrap(data), Frame.NULL_BYTEBUFFER);
    }

    public PayloadImpl(byte[] data, byte[] metadata) {
        this(ByteBuffer.wrap(data), ByteBuffer.wrap(metadata));
    }

    public PayloadImpl(ByteBuffer data) {
        this(data, Frame.NULL_BYTEBUFFER);
    }

    public PayloadImpl(ByteBuffer data, ByteBuffer metadata) {
        this(data, metadata, true);
    }

    public PayloadImpl(ByteBuffer data, ByteBuffer metadata, boolean reusable) {
        this.data = data;
        this.reusable = reusable;
        this.metadata = null == metadata ? Frame.NULL_BYTEBUFFER : metadata;
        this.dataStartPosition = reusable ? this.data.position() : 0;
        this.metadataStartPosition = reusable ? this.metadata.position() : 0;
    }

    @Override
    public ByteBuffer getData() {
        if (this.reusable) {
            this.data.position(this.dataStartPosition);
        }
        return this.data;
    }

    @Override
    public ByteBuffer getMetadata() {
        if (this.reusable) {
            this.metadata.position(this.metadataStartPosition);
        }
        return this.metadata;
    }

    private static ByteBuffer fromString(String data) {
        return PayloadImpl.fromString(data, Charset.defaultCharset());
    }

    private static ByteBuffer fromString(String data, Charset charset) {
        return data == null ? Frame.NULL_BYTEBUFFER : ByteBuffer.wrap(data.getBytes(charset));
    }
}

