/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.lease;

import io.reactivesocket.Frame;
import io.reactivesocket.lease.Lease;
import java.nio.ByteBuffer;

public final class LeaseImpl
implements Lease {
    private final int allowedRequests;
    private final int ttl;
    private final long expiry;
    private final ByteBuffer metadata;

    public LeaseImpl(int allowedRequests, int ttl, ByteBuffer metadata) {
        this.allowedRequests = allowedRequests;
        this.ttl = ttl;
        this.expiry = System.currentTimeMillis() + (long)ttl;
        this.metadata = metadata;
    }

    public LeaseImpl(Frame leaseFrame) {
        this(Frame.Lease.numberOfRequests(leaseFrame), Frame.Lease.ttl(leaseFrame), leaseFrame.getMetadata());
    }

    @Override
    public int getAllowedRequests() {
        return this.allowedRequests;
    }

    @Override
    public int getTtl() {
        return this.ttl;
    }

    @Override
    public long expiry() {
        return this.expiry;
    }

    @Override
    public ByteBuffer metadata() {
        return this.metadata;
    }

    public String toString() {
        return "LeaseImpl{allowedRequests=" + this.allowedRequests + ", ttl=" + this.ttl + ", expiry=" + this.expiry + '}';
    }
}

