/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.lease;

import io.reactivesocket.Payload;
import io.reactivesocket.ReactiveSocket;
import io.reactivesocket.exceptions.RejectedException;
import io.reactivesocket.lease.Lease;
import io.reactivesocket.lease.LeaseHonoringSocket;
import io.reactivesocket.reactivestreams.extensions.Px;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLeaseHonoringSocket
implements LeaseHonoringSocket {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLeaseHonoringSocket.class);
    private volatile Lease currentLease;
    private final ReactiveSocket delegate;
    private final LongSupplier currentTimeSupplier;
    private final AtomicInteger remainingQuota;
    private static final RejectedException rejectedException = new RejectedException("Lease exhausted.");
    private static final Px rejectedPx = Px.error((Throwable)rejectedException);

    public DefaultLeaseHonoringSocket(ReactiveSocket delegate, LongSupplier currentTimeSupplier) {
        this.delegate = delegate;
        this.currentTimeSupplier = currentTimeSupplier;
        this.remainingQuota = new AtomicInteger();
    }

    public DefaultLeaseHonoringSocket(ReactiveSocket delegate) {
        this(delegate, System::currentTimeMillis);
    }

    @Override
    public void accept(Lease lease) {
        this.currentLease = lease;
        this.remainingQuota.set(lease.getAllowedRequests());
    }

    @Override
    public Publisher<Void> fireAndForget(Payload payload) {
        return Px.defer(() -> {
            if (!this.checkLease()) {
                return this.rejectError();
            }
            return this.delegate.fireAndForget(payload);
        });
    }

    @Override
    public Publisher<Payload> requestResponse(Payload payload) {
        return Px.defer(() -> {
            if (!this.checkLease()) {
                return this.rejectError();
            }
            return this.delegate.requestResponse(payload);
        });
    }

    @Override
    public Publisher<Payload> requestStream(Payload payload) {
        return Px.defer(() -> {
            if (!this.checkLease()) {
                return this.rejectError();
            }
            return this.delegate.requestStream(payload);
        });
    }

    @Override
    public Publisher<Payload> requestSubscription(Payload payload) {
        return Px.defer(() -> {
            if (!this.checkLease()) {
                return this.rejectError();
            }
            return this.delegate.requestSubscription(payload);
        });
    }

    @Override
    public Publisher<Payload> requestChannel(Publisher<Payload> payloads) {
        return Px.defer(() -> {
            if (!this.checkLease()) {
                return this.rejectError();
            }
            return this.delegate.requestChannel(payloads);
        });
    }

    @Override
    public Publisher<Void> metadataPush(Payload payload) {
        return Px.defer(() -> {
            if (!this.checkLease()) {
                return this.rejectError();
            }
            return this.delegate.metadataPush(payload);
        });
    }

    @Override
    public double availability() {
        return this.remainingQuota.get() <= 0 || this.currentLease.isExpired() ? 0.0 : this.delegate.availability();
    }

    @Override
    public Publisher<Void> close() {
        return this.delegate.close();
    }

    @Override
    public Publisher<Void> onClose() {
        return this.delegate.onClose();
    }

    protected <T> Publisher<T> rejectError() {
        return rejectedPx;
    }

    private boolean checkLease() {
        boolean allow;
        boolean bl = allow = this.remainingQuota.getAndDecrement() > 0 && !this.currentLease.isExpired(this.currentTimeSupplier.getAsLong());
        if (!allow && logger.isDebugEnabled()) {
            logger.debug("Lease expired. Lease: " + this.currentLease + ", remaining quota: " + Math.max(0, this.remainingQuota.get()) + ", current time (ms) " + this.currentTimeSupplier.getAsLong());
        }
        return allow;
    }
}

