/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.internal;

import io.reactivesocket.Frame;
import io.reactivesocket.FrameType;
import io.reactivesocket.reactivestreams.extensions.internal.FlowControlHelper;
import io.reactivesocket.reactivestreams.extensions.internal.ValidatingSubscription;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class RemoteSender
implements Processor<Frame, Frame>,
Subscription {
    private final Publisher<Frame> originalSource;
    private final Runnable cleanup;
    private final int streamId;
    private volatile ValidatingSubscription<? super Frame> transportSubscription;
    private volatile Subscription sourceSubscription;
    private int transportRequested;
    private int remoteRequested;
    private int outstanding;
    private Frame bufferedTerminalFrame;
    private Throwable bufferedTransportError;

    public RemoteSender(Publisher<Frame> originalSource, Runnable cleanup, int streamId, int initialRemoteRequested) {
        this.originalSource = originalSource;
        this.cleanup = cleanup;
        this.streamId = streamId;
        this.remoteRequested = initialRemoteRequested;
    }

    public RemoteSender(Publisher<Frame> originalSource, Runnable cleanup, int streamId) {
        this(originalSource, cleanup, streamId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Subscriber<? super Frame> s) {
        ValidatingSubscription<? super Frame> sub;
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (this.transportSubscription != null && this.transportSubscription.isActive()) {
                throw new IllegalStateException("Duplicate subscriptions not allowed.");
            }
            this.transportSubscription = ValidatingSubscription.create(s, () -> {
                Subscription sourceSub;
                RemoteSender remoteSender = this;
                synchronized (remoteSender) {
                    if (this.sourceSubscription == null) {
                        return;
                    }
                    sourceSub = this.sourceSubscription;
                }
                sourceSub.cancel();
                this.cleanup.run();
            }, requestN -> {
                Frame bufferedTerminalFrame;
                RemoteSender remoteSender = this;
                synchronized (remoteSender) {
                    bufferedTerminalFrame = this.bufferedTerminalFrame;
                    this.transportRequested = FlowControlHelper.incrementRequestN((int)this.transportRequested, (long)requestN);
                }
                if (bufferedTerminalFrame != null) {
                    this.unsafeSendTerminalFrameToTransport(bufferedTerminalFrame, this.bufferedTransportError);
                    this.cleanup.run();
                } else {
                    this.tryRequestN();
                }
            });
            sub = this.transportSubscription;
        }
        s.onSubscribe(sub);
        this.originalSource.subscribe((Subscriber)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(Subscription s) {
        boolean cancelThis;
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            boolean bl = cancelThis = this.sourceSubscription != null || !this.transportSubscription.isActive();
            if (!cancelThis) {
                this.sourceSubscription = s;
            }
        }
        if (cancelThis) {
            s.cancel();
        } else {
            this.tryRequestN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(Frame frame) {
        FrameType frameType = frame.getType();
        assert (frameType != FrameType.ERROR && !RemoteSender.isCompleteFrame(frameType));
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            --this.outstanding;
        }
        this.transportSubscription.safeOnNext((Object)frame);
    }

    public void onError(Throwable t) {
        if (this.trySendTerminalFrame(Frame.Error.from(this.streamId, t), t)) {
            this.transportSubscription.safeOnError(t);
            this.cleanup.run();
        }
    }

    public void onComplete() {
        if (this.trySendTerminalFrame(Frame.Response.from(this.streamId, FrameType.COMPLETE), null)) {
            this.transportSubscription.safeOnComplete();
            this.cleanup.run();
        }
    }

    public void acceptRequestNFrame(Frame requestNFrame) {
        this.request(Frame.RequestN.requestN(requestNFrame));
    }

    public void acceptCancelFrame(Frame cancelFrame) {
        assert (cancelFrame.getType() == FrameType.CANCEL);
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void request(long requestN) {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            this.remoteRequested = FlowControlHelper.incrementRequestN((int)this.remoteRequested, (long)requestN);
        }
        this.tryRequestN();
    }

    public void cancel() {
        this.sourceSubscription.cancel();
        this.transportSubscription.cancel();
        this.cleanup.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryRequestN() {
        int _toRequest;
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (this.sourceSubscription == null) {
                return;
            }
            _toRequest = Math.min(this.transportRequested, this.remoteRequested);
            this.outstanding = FlowControlHelper.incrementRequestN((int)this.outstanding, (int)_toRequest);
            if (this.outstanding < this.transportRequested) {
                ++this.outstanding;
            }
            this.transportRequested -= _toRequest;
            this.remoteRequested -= _toRequest;
        }
        if (_toRequest > 0) {
            this.sourceSubscription.request((long)_toRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean trySendTerminalFrame(Frame frame, Throwable optionalError) {
        boolean send;
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            boolean bl = send = this.outstanding > 0;
            if (!send && this.bufferedTerminalFrame == null) {
                this.bufferedTerminalFrame = frame;
                this.bufferedTransportError = optionalError;
            }
        }
        if (send) {
            this.unsafeSendTerminalFrameToTransport(frame, optionalError);
        }
        return send;
    }

    private void unsafeSendTerminalFrameToTransport(Frame terminalFrame, Throwable optionalError) {
        this.transportSubscription.safeOnNext((Object)terminalFrame);
        if (terminalFrame.getType() == FrameType.COMPLETE || terminalFrame.getType() == FrameType.NEXT_COMPLETE) {
            this.transportSubscription.safeOnComplete();
        } else {
            this.transportSubscription.safeOnError(optionalError);
        }
    }

    private static boolean isCompleteFrame(FrameType frameType) {
        return frameType == FrameType.COMPLETE || frameType == FrameType.NEXT_COMPLETE;
    }
}

