/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.internal;

import io.reactivesocket.DuplexConnection;
import io.reactivesocket.Frame;
import io.reactivesocket.Payload;
import io.reactivesocket.exceptions.ApplicationException;
import io.reactivesocket.exceptions.CancelException;
import io.reactivesocket.reactivestreams.extensions.internal.FlowControlHelper;
import io.reactivesocket.reactivestreams.extensions.internal.ValidatingSubscription;
import io.reactivesocket.reactivestreams.extensions.internal.subscribers.Subscribers;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class RemoteReceiver
implements Processor<Frame, Payload> {
    private final Publisher<Frame> transportSource;
    private final DuplexConnection connection;
    private final int streamId;
    private final Runnable cleanup;
    private final Frame requestFrame;
    private final Subscription transportSubscription;
    private final boolean sendRequestN;
    private volatile ValidatingSubscription<? super Frame> subscription;
    private volatile Subscription sourceSubscription;
    private volatile boolean missedComplete;
    private volatile Throwable missedError;

    public RemoteReceiver(Publisher<Frame> transportSource, DuplexConnection connection, int streamId, Runnable cleanup, boolean sendRequestN) {
        this.transportSource = transportSource;
        this.connection = connection;
        this.streamId = streamId;
        this.cleanup = cleanup;
        this.sendRequestN = sendRequestN;
        this.requestFrame = null;
        this.transportSubscription = null;
    }

    public RemoteReceiver(DuplexConnection connection, int streamId, Runnable cleanup, Frame requestFrame, Subscription transportSubscription, boolean sendRequestN) {
        this.requestFrame = requestFrame;
        this.transportSubscription = transportSubscription;
        this.transportSource = null;
        this.connection = connection;
        this.streamId = streamId;
        this.cleanup = cleanup;
        this.sendRequestN = sendRequestN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Subscriber<? super Payload> s) {
        boolean _missed;
        SubscriptionFramesSource framesSource = new SubscriptionFramesSource();
        RemoteReceiver remoteReceiver = this;
        synchronized (remoteReceiver) {
            if (this.subscription != null && this.subscription.isActive()) {
                throw new IllegalStateException("Duplicate subscriptions not allowed.");
            }
            boolean bl = _missed = this.missedComplete || null != this.missedError;
            if (!_missed) {
                this.subscription = ValidatingSubscription.create(s, () -> {
                    this.sourceSubscription.cancel();
                    framesSource.sendCancel();
                    this.cleanup.run();
                }, requestN -> {
                    this.sourceSubscription.request(requestN);
                    if (this.sendRequestN) {
                        framesSource.sendRequestN(requestN);
                    }
                });
            }
        }
        if (_missed) {
            s.onSubscribe(ValidatingSubscription.empty());
            if (null != this.missedError) {
                s.onError(this.missedError);
            } else {
                s.onComplete();
            }
            return;
        }
        if (this.transportSource != null) {
            this.transportSource.subscribe((Subscriber)this);
        } else if (this.transportSubscription != null) {
            this.onSubscribe(this.transportSubscription);
            this.onNext(this.requestFrame);
        }
        this.connection.send(framesSource).subscribe((Subscriber)Subscribers.doOnError(throwable -> this.subscription.safeOnError(throwable)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(Subscription s) {
        boolean cancelThis;
        RemoteReceiver remoteReceiver = this;
        synchronized (remoteReceiver) {
            boolean bl = cancelThis = this.sourceSubscription != null || !this.subscription.isActive();
            if (!cancelThis) {
                this.sourceSubscription = s;
            }
        }
        if (cancelThis) {
            s.cancel();
        } else {
            this.subscription.getSubscriber().onSubscribe(this.subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(Frame frame) {
        RemoteReceiver remoteReceiver = this;
        synchronized (remoteReceiver) {
            if (this.subscription == null) {
                throw new IllegalStateException("Received onNext before subscription.");
            }
        }
        switch (frame.getType()) {
            case ERROR: {
                this.onError(new ApplicationException(frame));
                break;
            }
            case NEXT: {
                this.subscription.safeOnNext((Object)frame);
                break;
            }
            case COMPLETE: {
                this.onComplete();
                break;
            }
            case NEXT_COMPLETE: {
                this.subscription.safeOnNext((Object)frame);
                this.onComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        boolean _missed = false;
        RemoteReceiver remoteReceiver = this;
        synchronized (remoteReceiver) {
            if (this.subscription == null) {
                _missed = true;
                this.missedError = t;
            }
        }
        if (!_missed) {
            this.subscription.safeOnError(t);
        }
        this.cleanup.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        boolean _missed = false;
        RemoteReceiver remoteReceiver = this;
        synchronized (remoteReceiver) {
            if (this.subscription == null) {
                _missed = true;
                this.missedComplete = true;
            }
        }
        if (!_missed) {
            this.subscription.safeOnComplete();
        }
        this.cleanup.run();
    }

    public void cancel() {
        this.sourceSubscription.cancel();
        this.onError(new CancelException("Remote subscription cancelled."));
    }

    private class SubscriptionFramesSource
    implements Publisher<Frame> {
        private ValidatingSubscription<? super Frame> subscription;
        private int requested;
        private int bufferedRequestN;
        private boolean bufferedCancel;

        private SubscriptionFramesSource() {
        }

        public void subscribe(Subscriber<? super Frame> s) {
            this.subscription = ValidatingSubscription.onRequestN(s, requestN -> {
                int n;
                boolean sendCancel;
                SubscriptionFramesSource subscriptionFramesSource = this;
                synchronized (subscriptionFramesSource) {
                    this.requested = FlowControlHelper.incrementRequestN((int)this.requested, (long)requestN);
                    sendCancel = this.bufferedCancel;
                    n = this.bufferedRequestN;
                }
                if (sendCancel) {
                    this.subscription.safeOnNext((Object)Frame.Cancel.from(RemoteReceiver.this.streamId));
                } else if (RemoteReceiver.this.sendRequestN && n > 0) {
                    this.subscription.safeOnNext((Object)Frame.RequestN.from(RemoteReceiver.this.streamId, n));
                }
            });
            s.onSubscribe(this.subscription);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendRequestN(long n) {
            int toRequest;
            ValidatingSubscription<? super Frame> sub;
            SubscriptionFramesSource subscriptionFramesSource = this;
            synchronized (subscriptionFramesSource) {
                sub = this.subscription;
                if (this.requested > 0) {
                    toRequest = FlowControlHelper.incrementRequestN((int)this.bufferedRequestN, (long)n);
                    this.bufferedRequestN = 0;
                    --this.requested;
                } else {
                    this.bufferedRequestN = FlowControlHelper.incrementRequestN((int)this.bufferedRequestN, (long)n);
                    toRequest = 0;
                }
            }
            if (sub != null && sub.isActive() && toRequest > 0) {
                sub.safeOnNext((Object)Frame.RequestN.from(RemoteReceiver.this.streamId, toRequest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendCancel() {
            boolean send;
            SubscriptionFramesSource subscriptionFramesSource = this;
            synchronized (subscriptionFramesSource) {
                boolean bl = send = this.requested > 0;
                if (send) {
                    --this.requested;
                } else {
                    this.bufferedCancel = true;
                }
            }
            if (send) {
                this.subscription.safeOnNext((Object)Frame.Cancel.from(RemoteReceiver.this.streamId));
            }
        }
    }
}

