/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.internal;

import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public final class KnownErrorFilter
implements Consumer<Throwable> {
    private static final List<Class<? extends Throwable>> knownErrors = Collections.singletonList(ClosedChannelException.class);
    private final Consumer<Throwable> delegate;

    public KnownErrorFilter(Consumer<Throwable> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void accept(Throwable throwable) {
        if (!knownErrors.contains(throwable.getClass())) {
            this.delegate.accept(throwable);
        }
    }
}

