/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.frame;

import io.reactivesocket.Frame;
import io.reactivesocket.frame.FramePool;
import java.nio.ByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.UnsafeBuffer;

public class ThreadSafeFramePool
implements FramePool {
    private static final int MAX_CACHED_FRAMES = 16;
    private final OneToOneConcurrentArrayQueue<Frame> frameQueue;
    private final OneToOneConcurrentArrayQueue<MutableDirectBuffer> directBufferQueue;

    public ThreadSafeFramePool() {
        this(16, 16);
    }

    public ThreadSafeFramePool(int frameQueueLength, int directBufferQueueLength) {
        this.frameQueue = new OneToOneConcurrentArrayQueue(frameQueueLength);
        this.directBufferQueue = new OneToOneConcurrentArrayQueue(directBufferQueueLength);
    }

    @Override
    public Frame acquireFrame(int size) {
        MutableDirectBuffer directBuffer = this.acquireMutableDirectBuffer(size);
        Frame frame = this.pollFrame();
        if (null == frame) {
            frame = Frame.allocate(directBuffer);
        }
        return frame;
    }

    @Override
    public Frame acquireFrame(ByteBuffer byteBuffer) {
        return Frame.allocate((MutableDirectBuffer)new UnsafeBuffer(byteBuffer));
    }

    @Override
    public Frame acquireFrame(MutableDirectBuffer mutableDirectBuffer) {
        Frame frame = this.pollFrame();
        if (null == frame) {
            frame = Frame.allocate(mutableDirectBuffer);
        }
        return frame;
    }

    @Override
    public MutableDirectBuffer acquireMutableDirectBuffer(ByteBuffer byteBuffer) {
        MutableDirectBuffer directBuffer = this.pollMutableDirectBuffer();
        if (null == directBuffer) {
            directBuffer = new UnsafeBuffer(byteBuffer);
        }
        return directBuffer;
    }

    @Override
    public MutableDirectBuffer acquireMutableDirectBuffer(int size) {
        UnsafeBuffer directBuffer = (UnsafeBuffer)this.pollMutableDirectBuffer();
        if (null == directBuffer || directBuffer.capacity() < size) {
            directBuffer = new UnsafeBuffer(ByteBuffer.allocate(size));
        } else {
            directBuffer.byteBuffer().limit(size).position(0);
        }
        return directBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Frame frame) {
        OneToOneConcurrentArrayQueue<Frame> oneToOneConcurrentArrayQueue = this.frameQueue;
        synchronized (oneToOneConcurrentArrayQueue) {
            this.frameQueue.offer((Object)frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(MutableDirectBuffer mutableDirectBuffer) {
        OneToOneConcurrentArrayQueue<MutableDirectBuffer> oneToOneConcurrentArrayQueue = this.directBufferQueue;
        synchronized (oneToOneConcurrentArrayQueue) {
            this.directBufferQueue.offer((Object)mutableDirectBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Frame pollFrame() {
        OneToOneConcurrentArrayQueue<Frame> oneToOneConcurrentArrayQueue = this.frameQueue;
        synchronized (oneToOneConcurrentArrayQueue) {
            return (Frame)this.frameQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutableDirectBuffer pollMutableDirectBuffer() {
        OneToOneConcurrentArrayQueue<MutableDirectBuffer> oneToOneConcurrentArrayQueue = this.directBufferQueue;
        synchronized (oneToOneConcurrentArrayQueue) {
            return (MutableDirectBuffer)this.directBufferQueue.poll();
        }
    }
}

