/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.frame;

import io.reactivesocket.Frame;
import io.reactivesocket.frame.FramePool;
import java.nio.ByteBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.UnsafeBuffer;

public class ThreadLocalFramePool
implements FramePool {
    private static final int MAX_CAHED_FRAMES_PER_THREAD = 16;
    private static final ThreadLocal<OneToOneConcurrentArrayQueue<Frame>> PER_THREAD_FRAME_QUEUE = ThreadLocal.withInitial(() -> new OneToOneConcurrentArrayQueue(16));
    private static final ThreadLocal<OneToOneConcurrentArrayQueue<MutableDirectBuffer>> PER_THREAD_DIRECTBUFFER_QUEUE = ThreadLocal.withInitial(() -> new OneToOneConcurrentArrayQueue(16));

    @Override
    public Frame acquireFrame(int size) {
        MutableDirectBuffer directBuffer = this.acquireMutableDirectBuffer(size);
        Frame frame = this.pollFrame();
        if (null == frame) {
            frame = Frame.allocate(directBuffer);
        }
        return frame;
    }

    @Override
    public Frame acquireFrame(ByteBuffer byteBuffer) {
        return Frame.allocate((MutableDirectBuffer)new UnsafeBuffer(byteBuffer));
    }

    @Override
    public void release(Frame frame) {
        PER_THREAD_FRAME_QUEUE.get().offer((Object)frame);
    }

    @Override
    public Frame acquireFrame(MutableDirectBuffer mutableDirectBuffer) {
        Frame frame = this.pollFrame();
        if (null == frame) {
            frame = Frame.allocate(mutableDirectBuffer);
        }
        return frame;
    }

    @Override
    public MutableDirectBuffer acquireMutableDirectBuffer(ByteBuffer byteBuffer) {
        MutableDirectBuffer directBuffer = this.pollMutableDirectBuffer();
        if (null == directBuffer) {
            directBuffer = new UnsafeBuffer(byteBuffer);
        }
        return directBuffer;
    }

    @Override
    public MutableDirectBuffer acquireMutableDirectBuffer(int size) {
        UnsafeBuffer directBuffer = (UnsafeBuffer)this.pollMutableDirectBuffer();
        if (null == directBuffer || directBuffer.byteBuffer().capacity() < size) {
            directBuffer = new UnsafeBuffer(ByteBuffer.allocate(size));
        } else {
            directBuffer.byteBuffer().limit(size).position(0);
        }
        return directBuffer;
    }

    @Override
    public void release(MutableDirectBuffer mutableDirectBuffer) {
        PER_THREAD_DIRECTBUFFER_QUEUE.get().offer((Object)mutableDirectBuffer);
    }

    private Frame pollFrame() {
        return (Frame)PER_THREAD_FRAME_QUEUE.get().poll();
    }

    private MutableDirectBuffer pollMutableDirectBuffer() {
        return (MutableDirectBuffer)PER_THREAD_DIRECTBUFFER_QUEUE.get().poll();
    }
}

