/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.frame;

import io.reactivesocket.FrameType;
import io.reactivesocket.frame.FrameHeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class SetupFrameFlyweight {
    public static final int FLAGS_WILL_HONOR_LEASE = 32;
    public static final int FLAGS_STRICT_INTERPRETATION = 16;
    public static final byte CURRENT_VERSION = 0;
    private static final int VERSION_FIELD_OFFSET = FrameHeaderFlyweight.FRAME_HEADER_LENGTH;
    private static final int KEEPALIVE_INTERVAL_FIELD_OFFSET = VERSION_FIELD_OFFSET + 4;
    private static final int MAX_LIFETIME_FIELD_OFFSET = KEEPALIVE_INTERVAL_FIELD_OFFSET + 4;
    private static final int METADATA_MIME_TYPE_LENGTH_OFFSET = MAX_LIFETIME_FIELD_OFFSET + 4;

    private SetupFrameFlyweight() {
    }

    public static int computeFrameLength(String metadataMimeType, String dataMimeType, int metadataLength, int dataLength) {
        int length = FrameHeaderFlyweight.computeFrameHeaderLength(FrameType.SETUP, metadataLength, dataLength);
        length += 12;
        length += 1 + metadataMimeType.getBytes(StandardCharsets.UTF_8).length;
        return length += 1 + dataMimeType.getBytes(StandardCharsets.UTF_8).length;
    }

    public static int encode(MutableDirectBuffer mutableDirectBuffer, int offset, int flags, int keepaliveInterval, int maxLifetime, String metadataMimeType, String dataMimeType, ByteBuffer metadata, ByteBuffer data) {
        int frameLength = SetupFrameFlyweight.computeFrameLength(metadataMimeType, dataMimeType, metadata.remaining(), data.remaining());
        int length = FrameHeaderFlyweight.encodeFrameHeader(mutableDirectBuffer, offset, frameLength, flags, FrameType.SETUP, 0);
        mutableDirectBuffer.putInt(offset + VERSION_FIELD_OFFSET, 0, ByteOrder.BIG_ENDIAN);
        mutableDirectBuffer.putInt(offset + KEEPALIVE_INTERVAL_FIELD_OFFSET, keepaliveInterval, ByteOrder.BIG_ENDIAN);
        mutableDirectBuffer.putInt(offset + MAX_LIFETIME_FIELD_OFFSET, maxLifetime, ByteOrder.BIG_ENDIAN);
        length += 12;
        length += SetupFrameFlyweight.putMimeType(mutableDirectBuffer, offset + length, metadataMimeType);
        length += SetupFrameFlyweight.putMimeType(mutableDirectBuffer, offset + length, dataMimeType);
        length += FrameHeaderFlyweight.encodeMetadata(mutableDirectBuffer, offset, offset + length, metadata);
        length += FrameHeaderFlyweight.encodeData(mutableDirectBuffer, offset + length, data);
        return length;
    }

    public static int version(DirectBuffer directBuffer, int offset) {
        return directBuffer.getInt(offset + VERSION_FIELD_OFFSET, ByteOrder.BIG_ENDIAN);
    }

    public static int keepaliveInterval(DirectBuffer directBuffer, int offset) {
        return directBuffer.getInt(offset + KEEPALIVE_INTERVAL_FIELD_OFFSET, ByteOrder.BIG_ENDIAN);
    }

    public static int maxLifetime(DirectBuffer directBuffer, int offset) {
        return directBuffer.getInt(offset + MAX_LIFETIME_FIELD_OFFSET, ByteOrder.BIG_ENDIAN);
    }

    public static String metadataMimeType(DirectBuffer directBuffer, int offset) {
        byte[] bytes = SetupFrameFlyweight.getMimeType(directBuffer, offset + METADATA_MIME_TYPE_LENGTH_OFFSET);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String dataMimeType(DirectBuffer directBuffer, int offset) {
        int fieldOffset = offset + METADATA_MIME_TYPE_LENGTH_OFFSET;
        fieldOffset += 1 + directBuffer.getByte(fieldOffset);
        byte[] bytes = SetupFrameFlyweight.getMimeType(directBuffer, fieldOffset);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static int payloadOffset(DirectBuffer directBuffer, int offset) {
        int fieldOffset = offset + METADATA_MIME_TYPE_LENGTH_OFFSET;
        byte metadataMimeTypeLength = directBuffer.getByte(fieldOffset);
        byte dataMimeTypeLength = directBuffer.getByte(fieldOffset += 1 + metadataMimeTypeLength);
        return fieldOffset += 1 + dataMimeTypeLength;
    }

    private static int putMimeType(MutableDirectBuffer mutableDirectBuffer, int fieldOffset, String mimeType) {
        byte[] bytes = mimeType.getBytes(StandardCharsets.UTF_8);
        mutableDirectBuffer.putByte(fieldOffset, (byte)bytes.length);
        mutableDirectBuffer.putBytes(fieldOffset + 1, bytes);
        return 1 + bytes.length;
    }

    private static byte[] getMimeType(DirectBuffer directBuffer, int fieldOffset) {
        byte length = directBuffer.getByte(fieldOffset);
        byte[] bytes = new byte[length];
        directBuffer.getBytes(fieldOffset + 1, bytes);
        return bytes;
    }
}

