/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.frame;

import io.reactivesocket.FrameType;
import io.reactivesocket.frame.FrameHeaderFlyweight;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class RequestNFrameFlyweight {
    private static final int REQUEST_N_FIELD_OFFSET = FrameHeaderFlyweight.FRAME_HEADER_LENGTH;

    private RequestNFrameFlyweight() {
    }

    public static int computeFrameLength() {
        int length = FrameHeaderFlyweight.computeFrameHeaderLength(FrameType.REQUEST_N, 0, 0);
        return length + 4;
    }

    public static int encode(MutableDirectBuffer mutableDirectBuffer, int offset, int streamId, int requestN) {
        int frameLength = RequestNFrameFlyweight.computeFrameLength();
        int length = FrameHeaderFlyweight.encodeFrameHeader(mutableDirectBuffer, offset, frameLength, 0, FrameType.REQUEST_N, streamId);
        mutableDirectBuffer.putInt(offset + REQUEST_N_FIELD_OFFSET, requestN, ByteOrder.BIG_ENDIAN);
        return length + 4;
    }

    public static int requestN(DirectBuffer directBuffer, int offset) {
        return directBuffer.getInt(offset + REQUEST_N_FIELD_OFFSET, ByteOrder.BIG_ENDIAN);
    }

    public static int payloadOffset(DirectBuffer directBuffer, int offset) {
        return offset + FrameHeaderFlyweight.FRAME_HEADER_LENGTH + 4;
    }
}

