/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.frame;

import io.reactivesocket.FrameType;
import io.reactivesocket.frame.FrameHeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class RequestFrameFlyweight {
    public static final int FLAGS_REQUEST_CHANNEL_C = 4096;
    public static final int FLAGS_REQUEST_CHANNEL_N = 2048;
    private static final int INITIAL_REQUEST_N_FIELD_OFFSET = FrameHeaderFlyweight.FRAME_HEADER_LENGTH;

    private RequestFrameFlyweight() {
    }

    public static int computeFrameLength(FrameType type, int metadataLength, int dataLength) {
        int length = FrameHeaderFlyweight.computeFrameHeaderLength(type, metadataLength, dataLength);
        if (type.hasInitialRequestN()) {
            length += 4;
        }
        return length;
    }

    public static int encode(MutableDirectBuffer mutableDirectBuffer, int offset, int streamId, int flags, FrameType type, int initialRequestN, ByteBuffer metadata, ByteBuffer data) {
        int frameLength = RequestFrameFlyweight.computeFrameLength(type, metadata.remaining(), data.remaining());
        int length = FrameHeaderFlyweight.encodeFrameHeader(mutableDirectBuffer, offset, frameLength, flags |= 0x800, type, streamId);
        mutableDirectBuffer.putInt(offset + INITIAL_REQUEST_N_FIELD_OFFSET, initialRequestN, ByteOrder.BIG_ENDIAN);
        length += 4;
        length += FrameHeaderFlyweight.encodeMetadata(mutableDirectBuffer, offset, offset + length, metadata);
        length += FrameHeaderFlyweight.encodeData(mutableDirectBuffer, offset + length, data);
        return length;
    }

    public static int encode(MutableDirectBuffer mutableDirectBuffer, int offset, int streamId, int flags, FrameType type, ByteBuffer metadata, ByteBuffer data) {
        int frameLength = RequestFrameFlyweight.computeFrameLength(type, metadata.remaining(), data.remaining());
        int length = FrameHeaderFlyweight.encodeFrameHeader(mutableDirectBuffer, offset, frameLength, flags, type, streamId);
        length += FrameHeaderFlyweight.encodeMetadata(mutableDirectBuffer, offset, offset + length, metadata);
        length += FrameHeaderFlyweight.encodeData(mutableDirectBuffer, offset + length, data);
        return length;
    }

    public static int initialRequestN(DirectBuffer directBuffer, int offset) {
        return directBuffer.getInt(offset + INITIAL_REQUEST_N_FIELD_OFFSET, ByteOrder.BIG_ENDIAN);
    }

    public static int payloadOffset(FrameType type, DirectBuffer directBuffer, int offset) {
        int result = offset + FrameHeaderFlyweight.FRAME_HEADER_LENGTH;
        if (type.hasInitialRequestN()) {
            result += 4;
        }
        return result;
    }
}

