/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.frame;

import io.reactivesocket.Frame;
import io.reactivesocket.Payload;
import io.reactivesocket.frame.PayloadBuilder;
import org.agrona.collections.Int2ObjectHashMap;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class PayloadReassembler
implements Subscriber<Frame> {
    private final Subscriber<? super Payload> child;
    private final Int2ObjectHashMap<PayloadBuilder> payloadByStreamId = new Int2ObjectHashMap();

    private PayloadReassembler(Subscriber<? super Payload> child) {
        this.child = child;
    }

    public static PayloadReassembler with(Subscriber<? super Payload> child) {
        return new PayloadReassembler(child);
    }

    public void resetStream(int streamId) {
        this.payloadByStreamId.remove(streamId);
    }

    public void onSubscribe(Subscription s) {
    }

    public void onNext(Frame frame) {
        int streamId = frame.getStreamId();
        PayloadBuilder payloadBuilder = (PayloadBuilder)this.payloadByStreamId.get(streamId);
        if (8192 != (frame.flags() & 0x2000)) {
            Payload deliveryPayload = frame;
            if (null != payloadBuilder) {
                payloadBuilder.append(frame);
                deliveryPayload = payloadBuilder.payload();
                this.payloadByStreamId.remove(streamId);
            }
            this.child.onNext((Object)deliveryPayload);
        } else {
            if (null == payloadBuilder) {
                payloadBuilder = new PayloadBuilder();
                this.payloadByStreamId.put(streamId, (Object)payloadBuilder);
            }
            payloadBuilder.append(frame);
        }
    }

    public void onError(Throwable t) {
    }

    public void onComplete() {
    }
}

