/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.frame;

import io.reactivesocket.Frame;
import io.reactivesocket.FrameType;
import io.reactivesocket.Payload;
import io.reactivesocket.frame.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class PayloadFragmenter
implements Iterable<Frame>,
Iterator<Frame> {
    private final int metadataMtu;
    private final int dataMtu;
    private ByteBuffer metadata;
    private ByteBuffer data;
    private Type type;
    private int metadataOffset;
    private int dataOffset;
    private int streamId;
    private int initialRequestN;

    public PayloadFragmenter(int metadataMtu, int dataMtu) {
        this.metadataMtu = metadataMtu;
        this.dataMtu = dataMtu;
    }

    public void resetForResponse(int streamId, Payload payload) {
        this.reset(streamId, payload);
        this.type = Type.RESPONSE;
    }

    public void resetForResponseComplete(int streamId, Payload payload) {
        this.reset(streamId, payload);
        this.type = Type.RESPONSE_COMPLETE;
    }

    public void resetForRequestChannel(int streamId, Payload payload, int initialRequestN) {
        this.reset(streamId, payload);
        this.type = Type.REQUEST_CHANNEL;
        this.initialRequestN = initialRequestN;
    }

    public static boolean requiresFragmenting(int metadataMtu, int dataMtu, Payload payload) {
        ByteBuffer metadata = payload.getMetadata();
        ByteBuffer data = payload.getData();
        return metadata.remaining() > metadataMtu || data.remaining() > dataMtu;
    }

    @Override
    public Iterator<Frame> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.dataOffset < this.data.remaining() || this.metadataOffset < this.metadata.remaining();
    }

    @Override
    public Frame next() {
        int metadataLength = Math.min(this.metadataMtu, this.metadata.remaining() - this.metadataOffset);
        int dataLength = Math.min(this.dataMtu, this.data.remaining() - this.dataOffset);
        Frame result = null;
        ByteBuffer metadataBuffer = metadataLength > 0 ? ByteBufferUtil.preservingSlice(this.metadata, this.metadataOffset, this.metadataOffset + metadataLength) : Frame.NULL_BYTEBUFFER;
        ByteBuffer dataBuffer = dataLength > 0 ? ByteBufferUtil.preservingSlice(this.data, this.dataOffset, this.dataOffset + dataLength) : Frame.NULL_BYTEBUFFER;
        this.metadataOffset += metadataLength;
        this.dataOffset += dataLength;
        boolean isMoreFollowing = this.metadataOffset < this.metadata.remaining() || this.dataOffset < this.data.remaining();
        int flags = 0;
        if (Type.RESPONSE == this.type) {
            if (isMoreFollowing) {
                flags |= 0x2000;
            }
            result = Frame.Response.from(this.streamId, FrameType.NEXT, metadataBuffer, dataBuffer, flags);
        }
        if (Type.RESPONSE_COMPLETE == this.type) {
            if (isMoreFollowing) {
                flags |= 0x2000;
            }
            result = Frame.Response.from(this.streamId, FrameType.NEXT_COMPLETE, metadataBuffer, dataBuffer, flags);
        } else if (Type.REQUEST_CHANNEL == this.type) {
            if (isMoreFollowing) {
                flags |= 0x2000;
            }
            result = Frame.Request.from(this.streamId, FrameType.REQUEST_CHANNEL, metadataBuffer, dataBuffer, this.initialRequestN, flags);
            this.initialRequestN = 0;
        }
        return result;
    }

    private void reset(int streamId, Payload payload) {
        this.data = payload.getData();
        this.metadata = payload.getMetadata();
        this.metadataOffset = 0;
        this.dataOffset = 0;
        this.streamId = streamId;
    }

    private static enum Type {
        RESPONSE,
        RESPONSE_COMPLETE,
        REQUEST_CHANNEL;

    }
}

