/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.frame;

import io.reactivesocket.Payload;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.agrona.BitUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class PayloadBuilder {
    public static final int INITIAL_CAPACITY = Math.max(32768, 32768);
    private final MutableDirectBuffer dataMutableDirectBuffer;
    private final MutableDirectBuffer metadataMutableDirectBuffer;
    private byte[] dataBuffer;
    private byte[] metadataBuffer;
    private int dataLimit = 0;
    private int metadataLimit = 0;
    private int dataCapacity = BitUtil.findNextPositivePowerOfTwo((int)INITIAL_CAPACITY);
    private int metadataCapacity = BitUtil.findNextPositivePowerOfTwo((int)INITIAL_CAPACITY);

    public PayloadBuilder() {
        this.dataBuffer = new byte[this.dataCapacity];
        this.metadataBuffer = new byte[this.metadataCapacity];
        this.dataMutableDirectBuffer = new UnsafeBuffer(this.dataBuffer);
        this.metadataMutableDirectBuffer = new UnsafeBuffer(this.metadataBuffer);
    }

    public Payload payload() {
        return new Payload(){

            @Override
            public ByteBuffer getData() {
                return ByteBuffer.wrap(PayloadBuilder.this.dataBuffer, 0, PayloadBuilder.this.dataLimit);
            }

            @Override
            public ByteBuffer getMetadata() {
                return ByteBuffer.wrap(PayloadBuilder.this.metadataBuffer, 0, PayloadBuilder.this.metadataLimit);
            }
        };
    }

    public void append(Payload payload) {
        ByteBuffer payloadMetadata = payload.getMetadata();
        ByteBuffer payloadData = payload.getData();
        int metadataLength = payloadMetadata.remaining();
        int dataLength = payloadData.remaining();
        this.ensureMetadataCapacity(metadataLength);
        this.ensureDataCapacity(dataLength);
        this.metadataMutableDirectBuffer.putBytes(this.metadataLimit, payloadMetadata, metadataLength);
        this.metadataLimit += metadataLength;
        this.dataMutableDirectBuffer.putBytes(this.dataLimit, payloadData, dataLength);
        this.dataLimit += dataLength;
    }

    private void ensureDataCapacity(int additionalCapacity) {
        int requiredCapacity = this.dataLimit + additionalCapacity;
        if (requiredCapacity < 0) {
            String s = String.format("Insufficient data capacity: dataLimit=%d additional=%d", this.dataLimit, additionalCapacity);
            throw new IllegalStateException(s);
        }
        if (requiredCapacity > this.dataCapacity) {
            int newCapacity = PayloadBuilder.findSuitableCapacity(this.dataCapacity, requiredCapacity);
            byte[] newBuffer = Arrays.copyOf(this.dataBuffer, newCapacity);
            this.dataCapacity = newCapacity;
            this.dataBuffer = newBuffer;
            this.dataMutableDirectBuffer.wrap(newBuffer);
        }
    }

    private void ensureMetadataCapacity(int additionalCapacity) {
        int requiredCapacity = this.metadataLimit + additionalCapacity;
        if (requiredCapacity < 0) {
            String s = String.format("Insufficient metadata capacity: metadataLimit=%d additional=%d", this.metadataLimit, additionalCapacity);
            throw new IllegalStateException(s);
        }
        if (requiredCapacity > this.metadataCapacity) {
            int newCapacity = PayloadBuilder.findSuitableCapacity(this.metadataCapacity, requiredCapacity);
            byte[] newBuffer = Arrays.copyOf(this.metadataBuffer, newCapacity);
            this.metadataCapacity = newCapacity;
            this.metadataBuffer = newBuffer;
            this.metadataMutableDirectBuffer.wrap(newBuffer);
        }
    }

    private static int findSuitableCapacity(int capacity, int requiredCapacity) {
        while ((capacity <<= 1) < requiredCapacity) {
        }
        return capacity;
    }
}

