/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.frame;

import io.reactivesocket.FrameType;
import io.reactivesocket.frame.FrameHeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class LeaseFrameFlyweight {
    private static final int TTL_FIELD_OFFSET = FrameHeaderFlyweight.FRAME_HEADER_LENGTH;
    private static final int NUM_REQUESTS_FIELD_OFFSET = TTL_FIELD_OFFSET + 4;
    private static final int PAYLOAD_OFFSET = NUM_REQUESTS_FIELD_OFFSET + 4;

    private LeaseFrameFlyweight() {
    }

    public static int computeFrameLength(int metadataLength) {
        int length = FrameHeaderFlyweight.computeFrameHeaderLength(FrameType.SETUP, metadataLength, 0);
        return length + 8;
    }

    public static int encode(MutableDirectBuffer mutableDirectBuffer, int offset, int ttl, int numRequests, ByteBuffer metadata) {
        int frameLength = LeaseFrameFlyweight.computeFrameLength(metadata.remaining());
        int length = FrameHeaderFlyweight.encodeFrameHeader(mutableDirectBuffer, offset, frameLength, 0, FrameType.LEASE, 0);
        mutableDirectBuffer.putInt(offset + TTL_FIELD_OFFSET, ttl, ByteOrder.BIG_ENDIAN);
        mutableDirectBuffer.putInt(offset + NUM_REQUESTS_FIELD_OFFSET, numRequests, ByteOrder.BIG_ENDIAN);
        length += 8;
        length += FrameHeaderFlyweight.encodeMetadata(mutableDirectBuffer, offset, offset + length, metadata);
        return length;
    }

    public static int ttl(DirectBuffer directBuffer, int offset) {
        return directBuffer.getInt(offset + TTL_FIELD_OFFSET, ByteOrder.BIG_ENDIAN);
    }

    public static int numRequests(DirectBuffer directBuffer, int offset) {
        return directBuffer.getInt(offset + NUM_REQUESTS_FIELD_OFFSET, ByteOrder.BIG_ENDIAN);
    }

    public static int payloadOffset(DirectBuffer directBuffer, int offset) {
        return offset + PAYLOAD_OFFSET;
    }
}

