/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.frame;

import io.reactivesocket.FrameType;
import io.reactivesocket.frame.FrameHeaderFlyweight;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class KeepaliveFrameFlyweight {
    private static final int PAYLOAD_OFFSET = FrameHeaderFlyweight.FRAME_HEADER_LENGTH;

    private KeepaliveFrameFlyweight() {
    }

    public static int computeFrameLength(int dataLength) {
        return FrameHeaderFlyweight.computeFrameHeaderLength(FrameType.SETUP, 0, dataLength);
    }

    public static int encode(MutableDirectBuffer mutableDirectBuffer, int offset, ByteBuffer data) {
        int frameLength = KeepaliveFrameFlyweight.computeFrameLength(data.remaining());
        int length = FrameHeaderFlyweight.encodeFrameHeader(mutableDirectBuffer, offset, frameLength, 0, FrameType.KEEPALIVE, 0);
        length += FrameHeaderFlyweight.encodeData(mutableDirectBuffer, offset + length, data);
        return length;
    }

    public static int payloadOffset(DirectBuffer directBuffer, int offset) {
        return offset + PAYLOAD_OFFSET;
    }
}

