/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.frame;

import io.reactivesocket.FrameType;
import io.reactivesocket.frame.ByteBufferUtil;
import io.reactivesocket.frame.ErrorFrameFlyweight;
import io.reactivesocket.frame.KeepaliveFrameFlyweight;
import io.reactivesocket.frame.LeaseFrameFlyweight;
import io.reactivesocket.frame.RequestFrameFlyweight;
import io.reactivesocket.frame.RequestNFrameFlyweight;
import io.reactivesocket.frame.SetupFrameFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class FrameHeaderFlyweight {
    public static final ByteBuffer NULL_BYTEBUFFER = ByteBuffer.allocate(0);
    public static final int FRAME_HEADER_LENGTH;
    private static final boolean INCLUDE_FRAME_LENGTH = true;
    private static final int FRAME_LENGTH_FIELD_OFFSET;
    private static final int TYPE_FIELD_OFFSET;
    private static final int FLAGS_FIELD_OFFSET;
    private static final int STREAM_ID_FIELD_OFFSET;
    private static final int PAYLOAD_OFFSET;
    public static final int FLAGS_I = 32768;
    public static final int FLAGS_M = 16384;
    public static final int FLAGS_KEEPALIVE_R = 8192;
    public static final int FLAGS_RESPONSE_F = 8192;
    public static final int FLAGS_RESPONSE_C = 4096;
    public static final int FLAGS_REQUEST_CHANNEL_F = 8192;

    private FrameHeaderFlyweight() {
    }

    public static int computeFrameHeaderLength(FrameType frameType, int metadataLength, int dataLength) {
        return PAYLOAD_OFFSET + FrameHeaderFlyweight.computeMetadataLength(metadataLength) + dataLength;
    }

    public static int encodeFrameHeader(MutableDirectBuffer mutableDirectBuffer, int offset, int frameLength, int flags, FrameType frameType, int streamId) {
        mutableDirectBuffer.putInt(offset + FRAME_LENGTH_FIELD_OFFSET, frameLength, ByteOrder.BIG_ENDIAN);
        mutableDirectBuffer.putShort(offset + TYPE_FIELD_OFFSET, (short)frameType.getEncodedType(), ByteOrder.BIG_ENDIAN);
        mutableDirectBuffer.putShort(offset + FLAGS_FIELD_OFFSET, (short)flags, ByteOrder.BIG_ENDIAN);
        mutableDirectBuffer.putInt(offset + STREAM_ID_FIELD_OFFSET, streamId, ByteOrder.BIG_ENDIAN);
        return FRAME_HEADER_LENGTH;
    }

    public static int encodeMetadata(MutableDirectBuffer mutableDirectBuffer, int frameHeaderStartOffset, int metadataOffset, ByteBuffer metadata) {
        int length = 0;
        int metadataLength = metadata.remaining();
        if (0 < metadataLength) {
            int flags = mutableDirectBuffer.getShort(frameHeaderStartOffset + FLAGS_FIELD_OFFSET, ByteOrder.BIG_ENDIAN);
            mutableDirectBuffer.putShort(frameHeaderStartOffset + FLAGS_FIELD_OFFSET, (short)(flags |= 0x4000), ByteOrder.BIG_ENDIAN);
            mutableDirectBuffer.putInt(metadataOffset, metadataLength + 4, ByteOrder.BIG_ENDIAN);
            mutableDirectBuffer.putBytes(metadataOffset + (length += 4), metadata, metadataLength);
            length += metadataLength;
        }
        return length;
    }

    public static int encodeData(MutableDirectBuffer mutableDirectBuffer, int dataOffset, ByteBuffer data) {
        int length = 0;
        int dataLength = data.remaining();
        if (0 < dataLength) {
            mutableDirectBuffer.putBytes(dataOffset, data, dataLength);
            length += dataLength;
        }
        return length;
    }

    public static int encode(MutableDirectBuffer mutableDirectBuffer, int offset, int streamId, int flags, FrameType frameType, ByteBuffer metadata, ByteBuffer data) {
        FrameType outFrameType;
        int frameLength = FrameHeaderFlyweight.computeFrameHeaderLength(frameType, metadata.remaining(), data.remaining());
        switch (frameType) {
            case NEXT_COMPLETE: 
            case COMPLETE: {
                outFrameType = FrameType.RESPONSE;
                flags |= 0x1000;
                break;
            }
            case NEXT: {
                outFrameType = FrameType.RESPONSE;
                break;
            }
            default: {
                outFrameType = frameType;
            }
        }
        int length = FrameHeaderFlyweight.encodeFrameHeader(mutableDirectBuffer, offset, frameLength, flags, outFrameType, streamId);
        length += FrameHeaderFlyweight.encodeMetadata(mutableDirectBuffer, offset, offset + length, metadata);
        length += FrameHeaderFlyweight.encodeData(mutableDirectBuffer, offset + length, data);
        return length;
    }

    public static int flags(DirectBuffer directBuffer, int offset) {
        return directBuffer.getShort(offset + FLAGS_FIELD_OFFSET, ByteOrder.BIG_ENDIAN);
    }

    public static FrameType frameType(DirectBuffer directBuffer, int offset) {
        FrameType result = FrameType.from(directBuffer.getShort(offset + TYPE_FIELD_OFFSET, ByteOrder.BIG_ENDIAN));
        if (FrameType.RESPONSE == result) {
            int flags = FrameHeaderFlyweight.flags(directBuffer, offset);
            boolean complete = 4096 == (flags & 0x1000);
            result = complete ? FrameType.NEXT_COMPLETE : FrameType.NEXT;
        }
        return result;
    }

    public static int streamId(DirectBuffer directBuffer, int offset) {
        return directBuffer.getInt(offset + STREAM_ID_FIELD_OFFSET, ByteOrder.BIG_ENDIAN);
    }

    public static ByteBuffer sliceFrameData(DirectBuffer directBuffer, int offset, int length) {
        int dataLength = FrameHeaderFlyweight.dataLength(directBuffer, offset, length);
        int dataOffset = FrameHeaderFlyweight.dataOffset(directBuffer, offset);
        ByteBuffer result = NULL_BYTEBUFFER;
        if (0 < dataLength) {
            result = ByteBufferUtil.preservingSlice(directBuffer.byteBuffer(), dataOffset, dataOffset + dataLength);
        }
        return result;
    }

    public static ByteBuffer sliceFrameMetadata(DirectBuffer directBuffer, int offset, int length) {
        int metadataLength = Math.max(0, FrameHeaderFlyweight.metadataFieldLength(directBuffer, offset) - 4);
        int metadataOffset = FrameHeaderFlyweight.metadataOffset(directBuffer, offset) + 4;
        ByteBuffer result = NULL_BYTEBUFFER;
        if (0 < metadataLength) {
            result = ByteBufferUtil.preservingSlice(directBuffer.byteBuffer(), metadataOffset, metadataOffset + metadataLength);
        }
        return result;
    }

    private static int frameLength(DirectBuffer directBuffer, int offset, int externalFrameLength) {
        int frameLength = externalFrameLength;
        frameLength = directBuffer.getInt(offset + FRAME_LENGTH_FIELD_OFFSET, ByteOrder.BIG_ENDIAN);
        return frameLength;
    }

    private static int computeMetadataLength(int metadataPayloadLength) {
        return metadataPayloadLength + (0 == metadataPayloadLength ? 0 : 4);
    }

    private static int metadataFieldLength(DirectBuffer directBuffer, int offset) {
        int metadataLength = 0;
        short flags = directBuffer.getShort(offset + FLAGS_FIELD_OFFSET, ByteOrder.BIG_ENDIAN);
        if (16384 == (0x4000 & flags)) {
            metadataLength = directBuffer.getInt(FrameHeaderFlyweight.metadataOffset(directBuffer, offset), ByteOrder.BIG_ENDIAN) & 0xFFFFFF;
        }
        return metadataLength;
    }

    private static int dataLength(DirectBuffer directBuffer, int offset, int externalLength) {
        int frameLength = FrameHeaderFlyweight.frameLength(directBuffer, offset, externalLength);
        int metadataLength = FrameHeaderFlyweight.metadataFieldLength(directBuffer, offset);
        return offset + frameLength - metadataLength - FrameHeaderFlyweight.payloadOffset(directBuffer, offset);
    }

    private static int payloadOffset(DirectBuffer directBuffer, int offset) {
        FrameType frameType = FrameType.from(directBuffer.getShort(offset + TYPE_FIELD_OFFSET, ByteOrder.BIG_ENDIAN));
        int result = offset + PAYLOAD_OFFSET;
        switch (frameType) {
            case SETUP: {
                result = SetupFrameFlyweight.payloadOffset(directBuffer, offset);
                break;
            }
            case ERROR: {
                result = ErrorFrameFlyweight.payloadOffset(directBuffer, offset);
                break;
            }
            case LEASE: {
                result = LeaseFrameFlyweight.payloadOffset(directBuffer, offset);
                break;
            }
            case KEEPALIVE: {
                result = KeepaliveFrameFlyweight.payloadOffset(directBuffer, offset);
                break;
            }
            case REQUEST_RESPONSE: 
            case FIRE_AND_FORGET: 
            case REQUEST_STREAM: 
            case REQUEST_SUBSCRIPTION: 
            case REQUEST_CHANNEL: {
                result = RequestFrameFlyweight.payloadOffset(frameType, directBuffer, offset);
                break;
            }
            case REQUEST_N: {
                result = RequestNFrameFlyweight.payloadOffset(directBuffer, offset);
            }
        }
        return result;
    }

    private static int metadataOffset(DirectBuffer directBuffer, int offset) {
        return FrameHeaderFlyweight.payloadOffset(directBuffer, offset);
    }

    private static int dataOffset(DirectBuffer directBuffer, int offset) {
        return FrameHeaderFlyweight.payloadOffset(directBuffer, offset) + FrameHeaderFlyweight.metadataFieldLength(directBuffer, offset);
    }

    static {
        FRAME_LENGTH_FIELD_OFFSET = 0;
        TYPE_FIELD_OFFSET = FRAME_LENGTH_FIELD_OFFSET + 4;
        FLAGS_FIELD_OFFSET = TYPE_FIELD_OFFSET + 2;
        STREAM_ID_FIELD_OFFSET = FLAGS_FIELD_OFFSET + 2;
        FRAME_HEADER_LENGTH = PAYLOAD_OFFSET = STREAM_ID_FIELD_OFFSET + 4;
    }
}

