/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.frame;

import io.reactivesocket.FrameType;
import io.reactivesocket.exceptions.ApplicationException;
import io.reactivesocket.exceptions.CancelException;
import io.reactivesocket.exceptions.ConnectionException;
import io.reactivesocket.exceptions.InvalidRequestException;
import io.reactivesocket.exceptions.InvalidSetupException;
import io.reactivesocket.exceptions.RejectedException;
import io.reactivesocket.exceptions.RejectedSetupException;
import io.reactivesocket.exceptions.UnsupportedSetupException;
import io.reactivesocket.frame.FrameHeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class ErrorFrameFlyweight {
    public static final int INVALID_SETUP = 1;
    public static final int UNSUPPORTED_SETUP = 2;
    public static final int REJECTED_SETUP = 3;
    public static final int CONNECTION_ERROR = 257;
    public static final int APPLICATION_ERROR = 513;
    public static final int REJECTED = 34;
    public static final int CANCEL = 515;
    public static final int INVALID = 516;
    private static final int ERROR_CODE_FIELD_OFFSET = FrameHeaderFlyweight.FRAME_HEADER_LENGTH;
    private static final int PAYLOAD_OFFSET = ERROR_CODE_FIELD_OFFSET + 4;

    private ErrorFrameFlyweight() {
    }

    public static int computeFrameLength(int metadataLength, int dataLength) {
        int length = FrameHeaderFlyweight.computeFrameHeaderLength(FrameType.ERROR, metadataLength, dataLength);
        return length + 4;
    }

    public static int encode(MutableDirectBuffer mutableDirectBuffer, int offset, int streamId, int errorCode, ByteBuffer metadata, ByteBuffer data) {
        int frameLength = ErrorFrameFlyweight.computeFrameLength(metadata.remaining(), data.remaining());
        int length = FrameHeaderFlyweight.encodeFrameHeader(mutableDirectBuffer, offset, frameLength, 0, FrameType.ERROR, streamId);
        mutableDirectBuffer.putInt(offset + ERROR_CODE_FIELD_OFFSET, errorCode, ByteOrder.BIG_ENDIAN);
        length += 4;
        length += FrameHeaderFlyweight.encodeMetadata(mutableDirectBuffer, offset, offset + length, metadata);
        length += FrameHeaderFlyweight.encodeData(mutableDirectBuffer, offset + length, data);
        return length;
    }

    public static int errorCodeFromException(Throwable ex) {
        if (ex instanceof InvalidSetupException) {
            return 1;
        }
        if (ex instanceof UnsupportedSetupException) {
            return 2;
        }
        if (ex instanceof RejectedSetupException) {
            return 3;
        }
        if (ex instanceof ConnectionException) {
            return 257;
        }
        if (ex instanceof InvalidRequestException) {
            return 516;
        }
        if (ex instanceof ApplicationException) {
            return 513;
        }
        if (ex instanceof RejectedException) {
            return 34;
        }
        if (ex instanceof CancelException) {
            return 515;
        }
        return 516;
    }

    public static int errorCode(DirectBuffer directBuffer, int offset) {
        return directBuffer.getInt(offset + ERROR_CODE_FIELD_OFFSET, ByteOrder.BIG_ENDIAN);
    }

    public static int payloadOffset(DirectBuffer directBuffer, int offset) {
        return offset + FrameHeaderFlyweight.FRAME_HEADER_LENGTH + 4;
    }
}

