/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.exceptions;

import io.reactivesocket.Frame;
import io.reactivesocket.exceptions.ApplicationException;
import io.reactivesocket.exceptions.ConnectionException;
import io.reactivesocket.exceptions.InvalidRequestException;
import io.reactivesocket.exceptions.InvalidSetupException;
import io.reactivesocket.exceptions.RejectedException;
import io.reactivesocket.exceptions.RejectedSetupException;
import io.reactivesocket.exceptions.UnsupportedSetupException;
import io.reactivesocket.frame.ByteBufferUtil;
import java.nio.ByteBuffer;

public class Exceptions {
    private Exceptions() {
    }

    public static RuntimeException from(Frame frame) {
        RuntimeException ex;
        int errorCode = Frame.Error.errorCode(frame);
        ByteBuffer dataBuffer = frame.getData();
        String message = dataBuffer.remaining() == 0 ? "<empty message>" : ByteBufferUtil.toUtf8String(dataBuffer);
        switch (errorCode) {
            case 513: {
                ex = new ApplicationException(frame);
                break;
            }
            case 257: {
                ex = new ConnectionException(message);
                break;
            }
            case 516: {
                ex = new InvalidRequestException(message);
                break;
            }
            case 1: {
                ex = new InvalidSetupException(message);
                break;
            }
            case 34: {
                ex = new RejectedException(message);
                break;
            }
            case 3: {
                ex = new RejectedSetupException(message);
                break;
            }
            case 2: {
                ex = new UnsupportedSetupException(message);
                break;
            }
            default: {
                ex = new InvalidRequestException("Invalid Error frame");
            }
        }
        return ex;
    }
}

