/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.events;

import io.reactivesocket.FrameType;
import io.reactivesocket.events.EventListener;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class LoggingEventListener
implements EventListener {
    private final Logger logger;
    protected final String name;
    protected final Level logLevel;

    public LoggingEventListener(String name, Level logLevel) {
        this.name = name;
        this.logLevel = logLevel;
        this.logger = LoggerFactory.getLogger((String)name);
    }

    @Override
    public void requestReceiveStart(int streamId, EventListener.RequestType type) {
        this.logIfEnabled(() -> this.name + ": requestReceiveStart streamId = [" + streamId + "], type = [" + (Object)((Object)type) + ']');
    }

    @Override
    public void requestReceiveComplete(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit) {
        this.logIfEnabled(() -> this.name + ": requestReceiveComplete streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + ']');
    }

    @Override
    public void requestReceiveFailed(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit, Throwable cause) {
        this.logIfEnabled(() -> this.name + ": requestReceiveFailed streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + "], cause = [" + cause + ']');
    }

    @Override
    public void requestReceiveCancelled(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit) {
        this.logIfEnabled(() -> this.name + ": requestReceiveCancelled streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + ']');
    }

    @Override
    public void requestSendStart(int streamId, EventListener.RequestType type) {
        this.logIfEnabled(() -> this.name + ": requestSendStart streamId = [" + streamId + "], type = [" + (Object)((Object)type) + ']');
    }

    @Override
    public void requestSendComplete(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit) {
        this.logIfEnabled(() -> this.name + ": requestSendComplete streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + ']');
    }

    @Override
    public void requestSendFailed(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit, Throwable cause) {
        this.logIfEnabled(() -> this.name + ": requestSendFailed streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + "], cause = [" + cause + ']');
    }

    @Override
    public void requestSendCancelled(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit) {
        this.logIfEnabled(() -> this.name + ": requestSendCancelled streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + ']');
    }

    @Override
    public void responseSendStart(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit) {
        this.logIfEnabled(() -> this.name + ": responseSendStart streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + ']');
    }

    @Override
    public void responseSendComplete(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit) {
        this.logIfEnabled(() -> this.name + ": responseSendComplete streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + ']');
    }

    @Override
    public void responseSendFailed(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit, Throwable cause) {
        System.out.println(this.name + ": responseSendFailed streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + "], cause = [" + cause + ']');
    }

    @Override
    public void responseSendCancelled(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit) {
        this.logIfEnabled(() -> this.name + ": responseSendCancelled streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + ']');
    }

    @Override
    public void responseReceiveStart(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit) {
        this.logIfEnabled(() -> this.name + ": responseReceiveStart streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + ']');
    }

    @Override
    public void responseReceiveComplete(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit) {
        this.logIfEnabled(() -> this.name + ": responseReceiveComplete streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + ']');
    }

    @Override
    public void responseReceiveFailed(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit, Throwable cause) {
        this.logIfEnabled(() -> this.name + ": responseReceiveFailed streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + "], cause = [" + cause + ']');
    }

    @Override
    public void responseReceiveCancelled(int streamId, EventListener.RequestType type, long duration, TimeUnit durationUnit) {
        this.logIfEnabled(() -> this.name + ": responseReceiveCancelled streamId = [" + streamId + "], type = [" + (Object)((Object)type) + "], duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + ']');
    }

    @Override
    public void socketClosed(long duration, TimeUnit durationUnit) {
        this.logIfEnabled(() -> this.name + ": socketClosed duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + ']');
    }

    @Override
    public void frameWritten(int streamId, FrameType frameType) {
        this.logIfEnabled(() -> this.name + ": frameWritten streamId = [" + streamId + "], frameType = [" + (Object)((Object)frameType) + ']');
    }

    @Override
    public void frameRead(int streamId, FrameType frameType) {
        this.logIfEnabled(() -> this.name + ": frameRead streamId = [" + streamId + "], frameType = [" + (Object)((Object)frameType) + ']');
    }

    @Override
    public void leaseSent(int permits, int ttl) {
        this.logIfEnabled(() -> this.name + ": leaseSent permits = [" + permits + "], ttl = [" + ttl + ']');
    }

    @Override
    public void leaseReceived(int permits, int ttl) {
        this.logIfEnabled(() -> this.name + ": leaseReceived permits = [" + permits + "], ttl = [" + ttl + ']');
    }

    @Override
    public void errorSent(int streamId, int errorCode) {
        this.logIfEnabled(() -> this.name + ": errorSent streamId = [" + streamId + "], errorCode = [" + errorCode + ']');
    }

    @Override
    public void errorReceived(int streamId, int errorCode) {
        this.logIfEnabled(() -> this.name + ": errorReceived streamId = [" + streamId + "], errorCode = [" + errorCode + ']');
    }

    @Override
    public void dispose() {
        this.logIfEnabled(() -> this.name + ": dispose");
    }

    protected void logIfEnabled(Supplier<String> logMsgSupplier) {
        switch (this.logLevel) {
            case ERROR: {
                if (!this.logger.isErrorEnabled()) break;
                this.logger.error(logMsgSupplier.get());
                break;
            }
            case WARN: {
                if (!this.logger.isWarnEnabled()) break;
                this.logger.warn(logMsgSupplier.get());
                break;
            }
            case INFO: {
                if (!this.logger.isInfoEnabled()) break;
                this.logger.info(logMsgSupplier.get());
                break;
            }
            case DEBUG: {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug(logMsgSupplier.get());
                break;
            }
            case TRACE: {
                if (!this.logger.isTraceEnabled()) break;
                this.logger.trace(logMsgSupplier.get());
            }
        }
    }
}

