/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.events;

import io.reactivesocket.events.EventListener;
import io.reactivesocket.events.EventPublishingSocket;
import io.reactivesocket.internal.EventPublisher;
import io.reactivesocket.reactivestreams.extensions.internal.publishers.InstrumentingPublisher;
import io.reactivesocket.util.Clock;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public class EventPublishingSocketImpl
implements EventPublishingSocket {
    private final EventPublisher<? extends EventListener> eventPublisher;
    private final boolean client;

    public EventPublishingSocketImpl(EventPublisher<? extends EventListener> eventPublisher, boolean client) {
        this.eventPublisher = eventPublisher;
        this.client = client;
    }

    @Override
    public <T> Publisher<T> decorateReceive(int streamId, Publisher<T> stream, EventListener.RequestType requestType) {
        long startTime = Clock.now();
        return new InstrumentingPublisher(stream, subscriber -> new ReceiveInterceptor(streamId, requestType, startTime), ReceiveInterceptor::receiveFailed, ReceiveInterceptor::receiveComplete, ReceiveInterceptor::receiveCancelled, null);
    }

    @Override
    public <T> Publisher<T> decorateSend(int streamId, Publisher<T> stream, long receiveStartTimeNanos, EventListener.RequestType requestType) {
        return new InstrumentingPublisher(stream, subscriber -> new SendInterceptor(streamId, requestType, receiveStartTimeNanos), SendInterceptor::sendFailed, SendInterceptor::sendComplete, SendInterceptor::sendCancelled, null);
    }

    private class SendInterceptor {
        private final long startTime;
        private final EventListener.RequestType requestType;
        private final int streamId;

        public SendInterceptor(int streamId, EventListener.RequestType requestType, long receiveStartTimeNanos) {
            this.streamId = streamId;
            this.startTime = Clock.now();
            this.requestType = requestType;
            if (EventPublishingSocketImpl.this.eventPublisher.isEventPublishingEnabled()) {
                Object eventListener = EventPublishingSocketImpl.this.eventPublisher.getEventListener();
                if (EventPublishingSocketImpl.this.client) {
                    eventListener.requestSendStart(streamId, requestType);
                } else {
                    eventListener.responseSendStart(streamId, requestType, Clock.elapsedSince(receiveStartTimeNanos), TimeUnit.NANOSECONDS);
                }
            }
        }

        public void sendComplete() {
            if (EventPublishingSocketImpl.this.eventPublisher.isEventPublishingEnabled()) {
                Object eventListener = EventPublishingSocketImpl.this.eventPublisher.getEventListener();
                if (EventPublishingSocketImpl.this.client) {
                    eventListener.requestSendComplete(this.streamId, this.requestType, Clock.elapsedSince(this.startTime), Clock.unit());
                } else {
                    eventListener.responseSendComplete(this.streamId, this.requestType, Clock.elapsedSince(this.startTime), Clock.unit());
                }
            }
        }

        public void sendFailed(Throwable cause) {
            if (EventPublishingSocketImpl.this.eventPublisher.isEventPublishingEnabled()) {
                Object eventListener = EventPublishingSocketImpl.this.eventPublisher.getEventListener();
                if (EventPublishingSocketImpl.this.client) {
                    eventListener.requestSendFailed(this.streamId, this.requestType, Clock.elapsedSince(this.startTime), Clock.unit(), cause);
                } else {
                    eventListener.responseSendFailed(this.streamId, this.requestType, Clock.elapsedSince(this.startTime), Clock.unit(), cause);
                }
            }
        }

        public void sendCancelled() {
            if (EventPublishingSocketImpl.this.eventPublisher.isEventPublishingEnabled()) {
                Object eventListener = EventPublishingSocketImpl.this.eventPublisher.getEventListener();
                if (EventPublishingSocketImpl.this.client) {
                    eventListener.requestSendCancelled(this.streamId, this.requestType, Clock.elapsedSince(this.startTime), Clock.unit());
                } else {
                    eventListener.responseSendCancelled(this.streamId, this.requestType, Clock.elapsedSince(this.startTime), Clock.unit());
                }
            }
        }
    }

    private class ReceiveInterceptor {
        private final long startTime;
        private final EventListener.RequestType requestType;
        private final int streamId;

        public ReceiveInterceptor(int streamId, EventListener.RequestType requestType, long startTime) {
            this.streamId = streamId;
            this.startTime = startTime;
            this.requestType = requestType;
            if (EventPublishingSocketImpl.this.eventPublisher.isEventPublishingEnabled()) {
                Object eventListener = EventPublishingSocketImpl.this.eventPublisher.getEventListener();
                if (EventPublishingSocketImpl.this.client) {
                    eventListener.responseReceiveStart(streamId, requestType, Clock.elapsedSince(startTime), Clock.unit());
                } else {
                    eventListener.requestReceiveStart(streamId, requestType);
                }
            }
        }

        public void receiveComplete() {
            if (EventPublishingSocketImpl.this.eventPublisher.isEventPublishingEnabled()) {
                Object eventListener = EventPublishingSocketImpl.this.eventPublisher.getEventListener();
                if (EventPublishingSocketImpl.this.client) {
                    eventListener.responseReceiveComplete(this.streamId, this.requestType, Clock.elapsedSince(this.startTime), Clock.unit());
                } else {
                    eventListener.requestReceiveComplete(this.streamId, this.requestType, Clock.elapsedSince(this.startTime), Clock.unit());
                }
            }
        }

        public void receiveFailed(Throwable cause) {
            if (EventPublishingSocketImpl.this.eventPublisher.isEventPublishingEnabled()) {
                Object eventListener = EventPublishingSocketImpl.this.eventPublisher.getEventListener();
                if (EventPublishingSocketImpl.this.client) {
                    eventListener.responseReceiveFailed(this.streamId, this.requestType, Clock.elapsedSince(this.startTime), Clock.unit(), cause);
                } else {
                    eventListener.requestReceiveFailed(this.streamId, this.requestType, Clock.elapsedSince(this.startTime), Clock.unit(), cause);
                }
            }
        }

        public void receiveCancelled() {
            if (EventPublishingSocketImpl.this.eventPublisher.isEventPublishingEnabled()) {
                Object eventListener = EventPublishingSocketImpl.this.eventPublisher.getEventListener();
                if (EventPublishingSocketImpl.this.client) {
                    eventListener.responseReceiveCancelled(this.streamId, this.requestType, Clock.elapsedSince(this.startTime), Clock.unit());
                } else {
                    eventListener.requestReceiveCancelled(this.streamId, this.requestType, Clock.elapsedSince(this.startTime), Clock.unit());
                }
            }
        }
    }
}

