/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.events;

import io.reactivesocket.FrameType;
import java.util.concurrent.TimeUnit;

public interface EventListener {
    default public void requestReceiveStart(int streamId, RequestType type) {
    }

    default public void requestReceiveComplete(int streamId, RequestType type, long duration, TimeUnit durationUnit) {
    }

    default public void requestReceiveFailed(int streamId, RequestType type, long duration, TimeUnit durationUnit, Throwable cause) {
    }

    default public void requestReceiveCancelled(int streamId, RequestType type, long duration, TimeUnit durationUnit) {
    }

    default public void requestSendStart(int streamId, RequestType type) {
    }

    default public void requestSendComplete(int streamId, RequestType type, long duration, TimeUnit durationUnit) {
    }

    default public void requestSendFailed(int streamId, RequestType type, long duration, TimeUnit durationUnit, Throwable cause) {
    }

    default public void requestSendCancelled(int streamId, RequestType type, long duration, TimeUnit durationUnit) {
    }

    default public void responseSendStart(int streamId, RequestType type, long duration, TimeUnit durationUnit) {
    }

    default public void responseSendComplete(int streamId, RequestType type, long duration, TimeUnit durationUnit) {
    }

    default public void responseSendFailed(int streamId, RequestType type, long duration, TimeUnit durationUnit, Throwable cause) {
    }

    default public void responseSendCancelled(int streamId, RequestType type, long duration, TimeUnit durationUnit) {
    }

    default public void responseReceiveStart(int streamId, RequestType type, long duration, TimeUnit durationUnit) {
    }

    default public void responseReceiveComplete(int streamId, RequestType type, long duration, TimeUnit durationUnit) {
    }

    default public void responseReceiveFailed(int streamId, RequestType type, long duration, TimeUnit durationUnit, Throwable cause) {
    }

    default public void responseReceiveCancelled(int streamId, RequestType type, long duration, TimeUnit durationUnit) {
    }

    default public void socketClosed(long duration, TimeUnit durationUnit) {
    }

    default public void frameWritten(int streamId, FrameType frameType) {
    }

    default public void frameRead(int streamId, FrameType frameType) {
    }

    default public void leaseSent(int permits, int ttl) {
    }

    default public void leaseReceived(int permits, int ttl) {
    }

    default public void errorSent(int streamId, int errorCode) {
    }

    default public void errorReceived(int streamId, int errorCode) {
    }

    default public void dispose() {
    }

    public static enum RequestType {
        RequestResponse,
        RequestStream,
        RequestChannel,
        MetadataPush,
        FireAndForget;


        public static RequestType fromFrameType(FrameType frameType) {
            switch (frameType) {
                case REQUEST_RESPONSE: {
                    return RequestResponse;
                }
                case FIRE_AND_FORGET: {
                    return FireAndForget;
                }
                case REQUEST_STREAM: {
                    return RequestStream;
                }
                case REQUEST_CHANNEL: {
                    return RequestChannel;
                }
                case METADATA_PUSH: {
                    return MetadataPush;
                }
            }
            throw new IllegalArgumentException("Unknown frame type: " + (Object)((Object)frameType));
        }
    }
}

