/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.client;

import io.reactivesocket.DuplexConnection;
import io.reactivesocket.Frame;
import io.reactivesocket.Payload;
import io.reactivesocket.ReactiveSocket;
import io.reactivesocket.client.KeepAliveProvider;
import io.reactivesocket.client.ReactiveSocketClient;
import io.reactivesocket.client.SetupProviderImpl;
import io.reactivesocket.events.ClientEventListener;
import io.reactivesocket.events.EventSource;
import io.reactivesocket.lease.DefaultLeaseHonoringSocket;
import io.reactivesocket.lease.DisableLeaseSocket;
import io.reactivesocket.lease.LeaseHonoringSocket;
import io.reactivesocket.util.PayloadImpl;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public interface SetupProvider
extends EventSource<ClientEventListener> {
    public static final int DEFAULT_FLAGS = 48;
    public static final int DEFAULT_MAX_KEEP_ALIVE_MISSING_ACK = 3;
    public static final String DEFAULT_METADATA_MIME_TYPE = "application/x.reactivesocket.meta+cbor";
    public static final String DEFAULT_DATA_MIME_TYPE = "application/binary";

    public Publisher<ReactiveSocket> accept(DuplexConnection var1, ReactiveSocketClient.SocketAcceptor var2);

    public SetupProvider dataMimeType(String var1);

    public SetupProvider metadataMimeType(String var1);

    public SetupProvider honorLease(Function<ReactiveSocket, LeaseHonoringSocket> var1);

    public SetupProvider disableLease();

    public SetupProvider disableLease(Function<ReactiveSocket, DisableLeaseSocket> var1);

    public SetupProvider setupPayload(Payload var1);

    public static SetupProvider keepAlive(KeepAliveProvider keepAliveProvider) {
        int period = keepAliveProvider.getKeepAlivePeriodMillis();
        Frame setupFrame = Frame.Setup.from(48, period, keepAliveProvider.getMissedKeepAliveThreshold() * period, DEFAULT_METADATA_MIME_TYPE, DEFAULT_DATA_MIME_TYPE, PayloadImpl.EMPTY);
        return new SetupProviderImpl(setupFrame, reactiveSocket -> new DefaultLeaseHonoringSocket((ReactiveSocket)reactiveSocket), keepAliveProvider, Throwable::printStackTrace);
    }
}

