/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.client;

import io.reactivesocket.AbstractReactiveSocket;
import io.reactivesocket.Availability;
import io.reactivesocket.ReactiveSocket;
import io.reactivesocket.client.DefaultReactiveSocketClient;
import io.reactivesocket.client.SetupProvider;
import io.reactivesocket.events.ClientEventListener;
import io.reactivesocket.events.EventSource;
import io.reactivesocket.lease.DisabledLeaseAcceptingSocket;
import io.reactivesocket.lease.LeaseEnforcingSocket;
import io.reactivesocket.transport.TransportClient;
import org.reactivestreams.Publisher;

public interface ReactiveSocketClient
extends Availability,
EventSource<ClientEventListener> {
    public Publisher<? extends ReactiveSocket> connect();

    public static ReactiveSocketClient create(TransportClient transportClient, SetupProvider setupProvider) {
        return ReactiveSocketClient.createDuplex(transportClient, reactiveSocket -> new DisabledLeaseAcceptingSocket(new AbstractReactiveSocket(){}), setupProvider);
    }

    public static ReactiveSocketClient createDuplex(TransportClient transportClient, SocketAcceptor acceptor, SetupProvider setupProvider) {
        return new DefaultReactiveSocketClient(transportClient, setupProvider, acceptor);
    }

    public static interface SocketAcceptor {
        public LeaseEnforcingSocket accept(ReactiveSocket var1);
    }
}

