/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket;

public enum FrameType {
    UNDEFINED(0),
    SETUP(1, 3),
    LEASE(2, 2),
    KEEPALIVE(3, 1),
    REQUEST_RESPONSE(4, 7),
    FIRE_AND_FORGET(5, 7),
    REQUEST_STREAM(6, 15),
    REQUEST_SUBSCRIPTION(7, 15),
    REQUEST_CHANNEL(8, 15),
    REQUEST_N(9),
    CANCEL(10, 2),
    RESPONSE(11, 3),
    ERROR(12, 3),
    METADATA_PUSH(13, 2),
    NEXT(14, 3),
    COMPLETE(15),
    NEXT_COMPLETE(16, 3),
    EXT(65535, 3);

    private static FrameType[] typesById;
    private final int id;
    private final int flags;

    private FrameType(int id) {
        this(id, 0);
    }

    private FrameType(int id, int flags) {
        this.id = id;
        this.flags = flags;
    }

    public int getEncodedType() {
        return this.id;
    }

    public boolean isRequestType() {
        return 4 == (this.flags & 4);
    }

    public boolean hasInitialRequestN() {
        return 8 == (this.flags & 8);
    }

    public boolean canHaveData() {
        return 1 == (this.flags & 1);
    }

    public boolean canHaveMetadata() {
        return 2 == (this.flags & 2);
    }

    public int payloadOffset() {
        return 0;
    }

    public static FrameType from(int id) {
        return typesById[id];
    }

    static {
        int max = 0;
        for (FrameType t : FrameType.values()) {
            max = Math.max(t.id, max);
        }
        typesById = new FrameType[max + 1];
        FrameType[] frameTypeArray = FrameType.values();
        int n = frameTypeArray.length;
        for (int i = 0; i < n; ++i) {
            FrameType t;
            FrameType.typesById[t.id] = t = frameTypeArray[i];
        }
    }

    private static class Flags {
        private static final int CAN_HAVE_DATA = 1;
        private static final int CAN_HAVE_METADATA = 2;
        private static final int CAN_HAVE_METADATA_AND_DATA = 3;
        private static final int IS_REQUEST_TYPE = 4;
        private static final int HAS_INITIAL_REQUEST_N = 8;

        private Flags() {
        }
    }
}

