/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket;

import io.reactivesocket.FrameType;
import io.reactivesocket.Payload;
import io.reactivesocket.frame.ErrorFrameFlyweight;
import io.reactivesocket.frame.FrameHeaderFlyweight;
import io.reactivesocket.frame.FramePool;
import io.reactivesocket.frame.LeaseFrameFlyweight;
import io.reactivesocket.frame.RequestFrameFlyweight;
import io.reactivesocket.frame.RequestNFrameFlyweight;
import io.reactivesocket.frame.SetupFrameFlyweight;
import io.reactivesocket.frame.UnpooledFrame;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Frame
implements Payload {
    private static final Logger logger;
    public static final ByteBuffer NULL_BYTEBUFFER;
    public static final int DATA_MTU = 32768;
    public static final int METADATA_MTU = 32768;
    private static final String FRAME_POOLER_CLASS_NAME;
    protected static final FramePool POOL;
    protected MutableDirectBuffer directBuffer;
    protected int offset = 0;
    protected int length = 0;

    protected Frame(MutableDirectBuffer directBuffer) {
        this.directBuffer = directBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.directBuffer.byteBuffer();
    }

    @Override
    public ByteBuffer getData() {
        return FrameHeaderFlyweight.sliceFrameData((DirectBuffer)this.directBuffer, this.offset, 0);
    }

    @Override
    public ByteBuffer getMetadata() {
        return FrameHeaderFlyweight.sliceFrameMetadata((DirectBuffer)this.directBuffer, this.offset, 0);
    }

    public int getStreamId() {
        return FrameHeaderFlyweight.streamId((DirectBuffer)this.directBuffer, this.offset);
    }

    public FrameType getType() {
        return FrameHeaderFlyweight.frameType((DirectBuffer)this.directBuffer, this.offset);
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public int flags() {
        return FrameHeaderFlyweight.flags((DirectBuffer)this.directBuffer, this.offset);
    }

    public void wrap(ByteBuffer byteBuffer, int offset) {
        this.wrap(POOL.acquireMutableDirectBuffer(byteBuffer), offset);
    }

    public void wrap(MutableDirectBuffer directBuffer, int offset) {
        this.directBuffer = directBuffer;
        this.offset = offset;
    }

    public static Frame from(ByteBuffer byteBuffer) {
        return POOL.acquireFrame(byteBuffer);
    }

    public static Frame from(DirectBuffer directBuffer, int offset, int length) {
        Frame frame = POOL.acquireFrame((MutableDirectBuffer)directBuffer);
        frame.offset = offset;
        frame.length = length;
        return frame;
    }

    public static Frame allocate(MutableDirectBuffer directBuffer) {
        return new Frame(directBuffer);
    }

    public void release() {
        POOL.release(this.directBuffer);
        POOL.release(this);
    }

    public void wrap(int streamId, FrameType type, ByteBuffer data) {
        POOL.release(this.directBuffer);
        this.directBuffer = POOL.acquireMutableDirectBuffer(FrameHeaderFlyweight.computeFrameHeaderLength(type, 0, data.remaining()));
        this.length = FrameHeaderFlyweight.encode(this.directBuffer, this.offset, streamId, 0, type, NULL_BYTEBUFFER, data);
    }

    public static void ensureFrameType(FrameType frameType, Frame frame) {
        FrameType typeInFrame = frame.getType();
        if (typeInFrame != frameType) {
            throw new AssertionError((Object)("expected " + (Object)((Object)frameType) + ", but saw" + (Object)((Object)typeInFrame)));
        }
    }

    public String toString() {
        FrameType type = FrameType.UNDEFINED;
        StringBuilder payload = new StringBuilder();
        long streamId = -1L;
        String additionalFlags = "";
        try {
            byte[] bytes;
            type = FrameHeaderFlyweight.frameType((DirectBuffer)this.directBuffer, 0);
            ByteBuffer byteBuffer = FrameHeaderFlyweight.sliceFrameMetadata((DirectBuffer)this.directBuffer, 0, 0);
            if (0 < byteBuffer.remaining()) {
                bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
                payload.append(String.format("metadata: \"%s\" ", new String(bytes, StandardCharsets.UTF_8)));
            }
            if (0 < (byteBuffer = FrameHeaderFlyweight.sliceFrameData((DirectBuffer)this.directBuffer, 0, 0)).remaining()) {
                bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
                payload.append(String.format("data: \"%s\"", new String(bytes, StandardCharsets.UTF_8)));
            }
            streamId = FrameHeaderFlyweight.streamId((DirectBuffer)this.directBuffer, 0);
            switch (type) {
                case LEASE: {
                    additionalFlags = " Permits: " + Lease.numberOfRequests(this) + " TTL: " + Lease.ttl(this);
                    break;
                }
                case REQUEST_N: {
                    additionalFlags = " RequestN: " + RequestN.requestN(this);
                    break;
                }
                case KEEPALIVE: {
                    additionalFlags = " Respond flag: " + Keepalive.hasRespondFlag(this);
                    break;
                }
                case REQUEST_STREAM: 
                case REQUEST_CHANNEL: {
                    additionalFlags = " Initial Request N: " + Request.initialRequestN(this);
                    break;
                }
                case ERROR: {
                    additionalFlags = " Error code: " + Error.errorCode(this);
                    break;
                }
                case SETUP: {
                    additionalFlags = " Version: " + Setup.version(this) + " keep-alive interval: " + Setup.keepaliveInterval(this) + " max lifetime: " + Setup.maxLifetime(this) + " metadata mime type: " + Setup.metadataMimeType(this) + " data mime type: " + Setup.dataMimeType(this);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error generating toString, ignored.", (Throwable)e);
        }
        return "Frame[" + this.offset + "] => Stream ID: " + streamId + " Type: " + (Object)((Object)type) + (!additionalFlags.isEmpty() ? additionalFlags : "") + " Payload: " + payload;
    }

    static {
        FramePool tmpPool;
        logger = LoggerFactory.getLogger(Frame.class);
        NULL_BYTEBUFFER = FrameHeaderFlyweight.NULL_BYTEBUFFER;
        FRAME_POOLER_CLASS_NAME = System.getProperty("io.reactivesocket.FramePool", UnpooledFrame.class.getName());
        try {
            logger.info("Creating thread pooled named " + FRAME_POOLER_CLASS_NAME);
            tmpPool = (FramePool)Class.forName(FRAME_POOLER_CLASS_NAME).newInstance();
        }
        catch (Exception ex) {
            logger.error("Error initializing frame pool.", (Throwable)ex);
            tmpPool = new UnpooledFrame();
        }
        POOL = tmpPool;
    }

    public static class Keepalive {
        private Keepalive() {
        }

        public static Frame from(ByteBuffer data, boolean respond) {
            Frame frame = POOL.acquireFrame(FrameHeaderFlyweight.computeFrameHeaderLength(FrameType.KEEPALIVE, 0, data.remaining()));
            int flags = respond ? 8192 : 0;
            frame.length = FrameHeaderFlyweight.encode(frame.directBuffer, frame.offset, 0, flags, FrameType.KEEPALIVE, NULL_BYTEBUFFER, data);
            return frame;
        }

        public static boolean hasRespondFlag(Frame frame) {
            Frame.ensureFrameType(FrameType.KEEPALIVE, frame);
            int flags = FrameHeaderFlyweight.flags((DirectBuffer)frame.directBuffer, frame.offset);
            return (flags & 0x2000) == 8192;
        }
    }

    public static class Cancel {
        private Cancel() {
        }

        public static Frame from(int streamId) {
            Frame frame = POOL.acquireFrame(FrameHeaderFlyweight.computeFrameHeaderLength(FrameType.CANCEL, 0, 0));
            frame.length = FrameHeaderFlyweight.encode(frame.directBuffer, frame.offset, streamId, 0, FrameType.CANCEL, NULL_BYTEBUFFER, NULL_BYTEBUFFER);
            return frame;
        }
    }

    public static class Response {
        private Response() {
        }

        public static Frame from(int streamId, FrameType type, Payload payload) {
            ByteBuffer data = payload.getData() != null ? payload.getData() : NULL_BYTEBUFFER;
            ByteBuffer metadata = payload.getMetadata() != null ? payload.getMetadata() : NULL_BYTEBUFFER;
            Frame frame = POOL.acquireFrame(FrameHeaderFlyweight.computeFrameHeaderLength(type, metadata.remaining(), data.remaining()));
            frame.length = FrameHeaderFlyweight.encode(frame.directBuffer, frame.offset, streamId, 0, type, metadata, data);
            return frame;
        }

        public static Frame from(int streamId, FrameType type, ByteBuffer metadata, ByteBuffer data, int flags) {
            Frame frame = POOL.acquireFrame(FrameHeaderFlyweight.computeFrameHeaderLength(type, metadata.remaining(), data.remaining()));
            frame.length = FrameHeaderFlyweight.encode(frame.directBuffer, frame.offset, streamId, flags, type, metadata, data);
            return frame;
        }

        public static Frame from(int streamId, FrameType type) {
            Frame frame = POOL.acquireFrame(FrameHeaderFlyweight.computeFrameHeaderLength(type, 0, 0));
            frame.length = FrameHeaderFlyweight.encode(frame.directBuffer, frame.offset, streamId, 0, type, NULL_BYTEBUFFER, NULL_BYTEBUFFER);
            return frame;
        }
    }

    public static class Request {
        private Request() {
        }

        public static Frame from(int streamId, FrameType type, Payload payload, int initialRequestN) {
            ByteBuffer d = payload.getData() != null ? payload.getData() : NULL_BYTEBUFFER;
            ByteBuffer md = payload.getMetadata() != null ? payload.getMetadata() : NULL_BYTEBUFFER;
            Frame frame = POOL.acquireFrame(RequestFrameFlyweight.computeFrameLength(type, md.remaining(), d.remaining()));
            frame.length = type.hasInitialRequestN() ? RequestFrameFlyweight.encode(frame.directBuffer, frame.offset, streamId, 0, type, initialRequestN, md, d) : RequestFrameFlyweight.encode(frame.directBuffer, frame.offset, streamId, 0, type, md, d);
            return frame;
        }

        public static Frame from(int streamId, FrameType type, int flags) {
            Frame frame = POOL.acquireFrame(RequestFrameFlyweight.computeFrameLength(type, 0, 0));
            frame.length = RequestFrameFlyweight.encode(frame.directBuffer, frame.offset, streamId, flags, type, NULL_BYTEBUFFER, NULL_BYTEBUFFER);
            return frame;
        }

        public static Frame from(int streamId, FrameType type, ByteBuffer metadata, ByteBuffer data, int initialRequestN, int flags) {
            Frame frame = POOL.acquireFrame(RequestFrameFlyweight.computeFrameLength(type, metadata.remaining(), data.remaining()));
            frame.length = RequestFrameFlyweight.encode(frame.directBuffer, frame.offset, streamId, flags, type, initialRequestN, metadata, data);
            return frame;
        }

        public static int initialRequestN(Frame frame) {
            int result;
            FrameType type = frame.getType();
            if (!type.isRequestType()) {
                throw new AssertionError((Object)("expected request type, but saw " + type.name()));
            }
            switch (frame.getType()) {
                case REQUEST_RESPONSE: {
                    result = 1;
                    break;
                }
                case FIRE_AND_FORGET: {
                    result = 0;
                    break;
                }
                default: {
                    result = RequestFrameFlyweight.initialRequestN((DirectBuffer)frame.directBuffer, frame.offset);
                }
            }
            return result;
        }

        public static boolean isRequestChannelComplete(Frame frame) {
            Frame.ensureFrameType(FrameType.REQUEST_CHANNEL, frame);
            int flags = FrameHeaderFlyweight.flags((DirectBuffer)frame.directBuffer, frame.offset);
            return (flags & 0x1000) == 4096;
        }
    }

    public static class RequestN {
        private RequestN() {
        }

        public static Frame from(int streamId, long requestN) {
            int v = requestN > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)requestN;
            return RequestN.from(streamId, v);
        }

        public static Frame from(int streamId, int requestN) {
            Frame frame = POOL.acquireFrame(RequestNFrameFlyweight.computeFrameLength());
            frame.length = RequestNFrameFlyweight.encode(frame.directBuffer, frame.offset, streamId, requestN);
            return frame;
        }

        public static int requestN(Frame frame) {
            Frame.ensureFrameType(FrameType.REQUEST_N, frame);
            return RequestNFrameFlyweight.requestN((DirectBuffer)frame.directBuffer, frame.offset);
        }
    }

    public static class Lease {
        private Lease() {
        }

        public static Frame from(int ttl, int numberOfRequests, ByteBuffer metadata) {
            Frame frame = POOL.acquireFrame(LeaseFrameFlyweight.computeFrameLength(metadata.remaining()));
            frame.length = LeaseFrameFlyweight.encode(frame.directBuffer, frame.offset, ttl, numberOfRequests, metadata);
            return frame;
        }

        public static int ttl(Frame frame) {
            Frame.ensureFrameType(FrameType.LEASE, frame);
            return LeaseFrameFlyweight.ttl((DirectBuffer)frame.directBuffer, frame.offset);
        }

        public static int numberOfRequests(Frame frame) {
            Frame.ensureFrameType(FrameType.LEASE, frame);
            return LeaseFrameFlyweight.numRequests((DirectBuffer)frame.directBuffer, frame.offset);
        }
    }

    public static class Error {
        private static final Logger errorLogger = LoggerFactory.getLogger(Error.class);

        private Error() {
        }

        public static Frame from(int streamId, Throwable throwable, ByteBuffer metadata, ByteBuffer data) {
            int code = ErrorFrameFlyweight.errorCodeFromException(throwable);
            Frame frame = POOL.acquireFrame(ErrorFrameFlyweight.computeFrameLength(metadata.remaining(), data.remaining()));
            if (errorLogger.isDebugEnabled()) {
                errorLogger.debug("an error occurred, creating error frame", throwable);
            }
            frame.length = ErrorFrameFlyweight.encode(frame.directBuffer, frame.offset, streamId, code, metadata, data);
            return frame;
        }

        public static Frame from(int streamId, Throwable throwable, ByteBuffer metadata) {
            String data = throwable.getMessage() == null ? "" : throwable.getMessage();
            byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
            ByteBuffer dataBuffer = ByteBuffer.wrap(bytes);
            return Error.from(streamId, throwable, metadata, dataBuffer);
        }

        public static Frame from(int streamId, Throwable throwable) {
            return Error.from(streamId, throwable, NULL_BYTEBUFFER);
        }

        public static int errorCode(Frame frame) {
            Frame.ensureFrameType(FrameType.ERROR, frame);
            return ErrorFrameFlyweight.errorCode((DirectBuffer)frame.directBuffer, frame.offset);
        }
    }

    public static class Setup {
        private Setup() {
        }

        public static Frame from(int flags, int keepaliveInterval, int maxLifetime, String metadataMimeType, String dataMimeType, Payload payload) {
            ByteBuffer metadata = payload.getMetadata();
            ByteBuffer data = payload.getData();
            Frame frame = POOL.acquireFrame(SetupFrameFlyweight.computeFrameLength(metadataMimeType, dataMimeType, metadata.remaining(), data.remaining()));
            frame.length = SetupFrameFlyweight.encode(frame.directBuffer, frame.offset, flags, keepaliveInterval, maxLifetime, metadataMimeType, dataMimeType, metadata, data);
            return frame;
        }

        public static int getFlags(Frame frame) {
            Frame.ensureFrameType(FrameType.SETUP, frame);
            int flags = FrameHeaderFlyweight.flags((DirectBuffer)frame.directBuffer, frame.offset);
            return flags & 0x30;
        }

        public static int version(Frame frame) {
            Frame.ensureFrameType(FrameType.SETUP, frame);
            return SetupFrameFlyweight.version((DirectBuffer)frame.directBuffer, frame.offset);
        }

        public static int keepaliveInterval(Frame frame) {
            Frame.ensureFrameType(FrameType.SETUP, frame);
            return SetupFrameFlyweight.keepaliveInterval((DirectBuffer)frame.directBuffer, frame.offset);
        }

        public static int maxLifetime(Frame frame) {
            Frame.ensureFrameType(FrameType.SETUP, frame);
            return SetupFrameFlyweight.maxLifetime((DirectBuffer)frame.directBuffer, frame.offset);
        }

        public static String metadataMimeType(Frame frame) {
            Frame.ensureFrameType(FrameType.SETUP, frame);
            return SetupFrameFlyweight.metadataMimeType((DirectBuffer)frame.directBuffer, frame.offset);
        }

        public static String dataMimeType(Frame frame) {
            Frame.ensureFrameType(FrameType.SETUP, frame);
            return SetupFrameFlyweight.dataMimeType((DirectBuffer)frame.directBuffer, frame.offset);
        }
    }
}

