/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket;

import io.reactivesocket.Frame;
import io.reactivesocket.FrameType;
import io.reactivesocket.Payload;
import java.nio.ByteBuffer;

public abstract class ConnectionSetupPayload
implements Payload {
    public static final int NO_FLAGS = 0;
    public static final int HONOR_LEASE = 32;
    public static final int STRICT_INTERPRETATION = 16;

    public static ConnectionSetupPayload create(String metadataMimeType, String dataMimeType) {
        return new ConnectionSetupPayloadImpl(metadataMimeType, dataMimeType, Frame.NULL_BYTEBUFFER, Frame.NULL_BYTEBUFFER, 0);
    }

    public static ConnectionSetupPayload create(String metadataMimeType, String dataMimeType, Payload payload) {
        return new ConnectionSetupPayloadImpl(metadataMimeType, dataMimeType, payload.getData(), payload.getMetadata(), 0);
    }

    public static ConnectionSetupPayload create(String metadataMimeType, String dataMimeType, int flags) {
        return new ConnectionSetupPayloadImpl(metadataMimeType, dataMimeType, Frame.NULL_BYTEBUFFER, Frame.NULL_BYTEBUFFER, flags);
    }

    public static ConnectionSetupPayload create(Frame setupFrame) {
        Frame.ensureFrameType(FrameType.SETUP, setupFrame);
        return new ConnectionSetupPayloadImpl(Frame.Setup.metadataMimeType(setupFrame), Frame.Setup.dataMimeType(setupFrame), setupFrame.getData(), setupFrame.getMetadata(), Frame.Setup.getFlags(setupFrame));
    }

    public abstract String metadataMimeType();

    public abstract String dataMimeType();

    public int getFlags() {
        return 32;
    }

    public boolean willClientHonorLease() {
        return 32 == (this.getFlags() & 0x20);
    }

    public boolean doesClientRequestStrictInterpretation() {
        return 16 == (this.getFlags() & 0x10);
    }

    private static final class ConnectionSetupPayloadImpl
    extends ConnectionSetupPayload {
        private final String metadataMimeType;
        private final String dataMimeType;
        private final ByteBuffer data;
        private final ByteBuffer metadata;
        private final int flags;

        public ConnectionSetupPayloadImpl(String metadataMimeType, String dataMimeType, ByteBuffer data, ByteBuffer metadata, int flags) {
            this.metadataMimeType = metadataMimeType;
            this.dataMimeType = dataMimeType;
            this.data = data;
            this.metadata = metadata;
            this.flags = flags;
        }

        @Override
        public String metadataMimeType() {
            return this.metadataMimeType;
        }

        @Override
        public String dataMimeType() {
            return this.dataMimeType;
        }

        @Override
        public ByteBuffer getData() {
            return this.data;
        }

        @Override
        public ByteBuffer getMetadata() {
            return this.metadata;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }
    }
}

