/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.sqlserver;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.jdbc.BaseJdbcClient;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.BooleanWriteFunction;
import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcErrorCode;
import io.prestosql.plugin.jdbc.JdbcExpression;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.plugin.jdbc.PredicatePushdownController;
import io.prestosql.plugin.jdbc.SliceWriteFunction;
import io.prestosql.plugin.jdbc.StandardColumnMappings;
import io.prestosql.plugin.jdbc.WriteMapping;
import io.prestosql.plugin.jdbc.expression.AggregateFunctionRewriter;
import io.prestosql.plugin.jdbc.expression.ImplementAvgDecimal;
import io.prestosql.plugin.jdbc.expression.ImplementAvgFloatingPoint;
import io.prestosql.plugin.jdbc.expression.ImplementCount;
import io.prestosql.plugin.jdbc.expression.ImplementCountAll;
import io.prestosql.plugin.jdbc.expression.ImplementMinMax;
import io.prestosql.plugin.jdbc.expression.ImplementSum;
import io.prestosql.plugin.sqlserver.ImplementAvgBigint;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.AggregateFunction;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class SqlServerClient
extends BaseJdbcClient {
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private static final int SQL_SERVER_MAX_LIST_EXPRESSIONS = 500;
    private final AggregateFunctionRewriter aggregateFunctionRewriter;
    private static final PredicatePushdownController SIMPLIFY_UNSUPPORTED_PUSHDOWN = domain -> {
        Domain pushedDown = domain;
        if (domain.getValues().getRanges().getRangeCount() > 500) {
            pushedDown = domain.simplify();
        }
        return new PredicatePushdownController.DomainPushdownResult(pushedDown, domain);
    };

    @Inject
    public SqlServerClient(BaseJdbcConfig config, ConnectionFactory connectionFactory) {
        super(config, "\"", connectionFactory);
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(-5, Optional.of("bigint"), 0, 0, Optional.empty(), Optional.empty());
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(arg_0 -> ((SqlServerClient)this).quoted(arg_0), (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementMinMax()).add((Object)new ImplementSum(SqlServerClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgDecimal()).add((Object)new ImplementAvgBigint()).build());
    }

    protected void renameTable(JdbcIdentity identity, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        if (!schemaName.equals(newTable.getSchemaName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table rename across schemas is not supported");
        }
        String sql = String.format("sp_rename %s, %s", SqlServerClient.singleQuote(catalogName, schemaName, tableName), SqlServerClient.singleQuote(newTable.getTableName()));
        this.execute(identity, sql);
    }

    public void renameColumn(JdbcIdentity identity, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        String sql = String.format("sp_rename %s, %s, 'COLUMN'", SqlServerClient.singleQuote(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName(), jdbcColumn.getColumnName()), SqlServerClient.singleQuote(newColumnName));
        this.execute(identity, sql);
    }

    protected void copyTableSchema(Connection connection, String catalogName, String schemaName, String tableName, String newTableName, List<String> columnNames) {
        String sql = String.format("SELECT %s INTO %s FROM %s WHERE 0 = 1", columnNames.stream().map(arg_0 -> ((SqlServerClient)this).quoted(arg_0)).collect(Collectors.joining(", ")), this.quoted(catalogName, schemaName, newTableName), this.quoted(catalogName, schemaName, tableName));
        this.execute(connection, sql);
    }

    public Optional<ColumnMapping> toPrestoType(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        String jdbcTypeName = (String)typeHandle.getJdbcTypeName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + typeHandle));
        if (jdbcTypeName.equals("varbinary")) {
            return Optional.of(SqlServerClient.varbinaryColumnMapping());
        }
        return super.toPrestoType(session, connection, typeHandle).map(columnMapping -> new ColumnMapping(columnMapping.getType(), columnMapping.getReadFunction(), columnMapping.getWriteFunction(), SIMPLIFY_UNSUPPORTED_PUSHDOWN));
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"bit", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (Varchars.isVarcharType((Type)type)) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() || varcharType.getBoundedLength() > 4000 ? "nvarchar(max)" : "nvarchar(" + varcharType.getBoundedLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            Object dataType = charType.getLength() > 4000 ? "nvarchar(max)" : "nchar(" + charType.getLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarbinaryType) {
            return WriteMapping.sliceMapping((String)"varbinary(max)", (SliceWriteFunction)SqlServerClient.varbinaryWriteFunction());
        }
        return super.toWriteMapping(session, type);
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(2, Optional.of("decimal"), decimalType.getPrecision(), decimalType.getScale(), Optional.empty(), Optional.empty()));
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> {
            String start = "SELECT ";
            Preconditions.checkArgument((boolean)sql.startsWith(start));
            return "SELECT TOP " + limit + " " + sql.substring(start.length());
        });
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    private static String singleQuote(String ... objects) {
        return SqlServerClient.singleQuote(DOT_JOINER.join((Object[])objects));
    }

    private static String singleQuote(String literal) {
        return "'" + literal + "'";
    }

    public static ColumnMapping varbinaryColumnMapping() {
        return ColumnMapping.sliceMapping((Type)VarbinaryType.VARBINARY, (resultSet, columnIndex) -> Slices.wrappedBuffer((byte[])resultSet.getBytes(columnIndex)), (SliceWriteFunction)SqlServerClient.varbinaryWriteFunction(), (PredicatePushdownController)ColumnMapping.DISABLE_PUSHDOWN);
    }

    private static SliceWriteFunction varbinaryWriteFunction() {
        return new SliceWriteFunction(){

            public void set(PreparedStatement statement, int index, Slice value) throws SQLException {
                statement.setBytes(index, value.getBytes());
            }

            public void setNull(PreparedStatement statement, int index) throws SQLException {
                statement.setBytes(index, null);
            }
        };
    }
}

