/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.sqlserver;

import com.google.common.base.Verify;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcExpression;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.plugin.jdbc.expression.AggregateFunctionPatterns;
import io.prestosql.plugin.jdbc.expression.AggregateFunctionRule;
import io.prestosql.spi.connector.AggregateFunction;
import io.prestosql.spi.expression.Variable;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import java.util.Optional;

public class ImplementAvgBigint
implements AggregateFunctionRule {
    private static final Capture<Variable> INPUT = Capture.newCapture();

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"avg")).with(AggregateFunctionPatterns.singleInput().matching(AggregateFunctionPatterns.variable().with(AggregateFunctionPatterns.expressionType().equalTo((Object)BigintType.BIGINT)).capturedAs(INPUT)));
    }

    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext context) {
        Variable input = (Variable)captures.get(INPUT);
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)context.getAssignments().get(input.getName());
        Verify.verifyNotNull((Object)columnHandle, (String)"Unbound variable: %s", (Object[])new Object[]{input});
        Verify.verify((aggregateFunction.getOutputType() == DoubleType.DOUBLE ? 1 : 0) != 0);
        return Optional.of(new JdbcExpression(String.format("avg(CAST(%s AS double precision))", columnHandle.toSqlExpression(context.getIdentifierQuote())), new JdbcTypeHandle(8, Optional.of("double"), 0, 0, Optional.empty(), Optional.empty())));
    }
}

