/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.sqlserver;

import io.prestosql.plugin.sqlserver.SqlServerQueryRunner;
import io.prestosql.plugin.sqlserver.TestingSqlServer;
import io.prestosql.testing.AbstractTestIntegrationSmokeTest;
import io.prestosql.testing.QueryRunner;
import io.prestosql.tpch.TpchTable;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestSqlServerIntegrationSmokeTest
extends AbstractTestIntegrationSmokeTest {
    protected TestingSqlServer sqlServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.sqlServer = new TestingSqlServer();
        this.sqlServer.start();
        return SqlServerQueryRunner.createSqlServerQueryRunner(this.sqlServer, TpchTable.CUSTOMER, TpchTable.NATION, TpchTable.ORDERS, TpchTable.REGION);
    }

    @AfterClass(alwaysRun=true)
    public final void destroy() {
        this.sqlServer.close();
    }

    @Test
    public void testInsert() {
        this.sqlServer.execute("CREATE TABLE test_insert (x bigint, y varchar(100))");
        this.assertUpdate("INSERT INTO test_insert VALUES (123, 'test')", 1L);
        this.assertQuery("SELECT * FROM test_insert", "SELECT 123 x, 'test' y");
        this.assertUpdate("DROP TABLE test_insert");
    }

    @Test
    public void testInsertInPresenceOfNotSupportedColumn() {
        this.sqlServer.execute("CREATE TABLE test_insert_not_supported_column_present(x bigint, y sql_variant, z varchar(10))");
        this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_name = 'test_insert_not_supported_column_present'", "VALUES 'x', 'z'");
        this.assertUpdate("INSERT INTO test_insert_not_supported_column_present (x, z) VALUES (123, 'test')", 1L);
        this.assertQuery("SELECT x, z FROM test_insert_not_supported_column_present", "SELECT 123, 'test'");
        this.assertUpdate("DROP TABLE test_insert_not_supported_column_present");
    }

    @Test
    public void testView() {
        this.sqlServer.execute("CREATE VIEW test_view AS SELECT * FROM orders");
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_view"));
        this.assertQuery("SELECT orderkey FROM test_view", "SELECT orderkey FROM orders");
        this.sqlServer.execute("DROP VIEW IF EXISTS test_view");
    }

    @Test
    public void testColumnComment() throws Exception {
        try (AutoCloseable ignoreTable = this.withTable("test_column_comment", "(col1 bigint, col2 bigint, col3 bigint)");){
            this.sqlServer.execute("EXEC sp_addextendedproperty  'MS_Description', 'test comment',  'Schema', 'dbo',  'Table', 'test_column_comment',  'Column', 'col1'");
            this.assertQuery("SELECT column_name, comment FROM information_schema.columns WHERE table_schema = 'dbo' AND table_name = 'test_column_comment'", "VALUES ('col1', null), ('col2', null), ('col3', null)");
        }
    }

    @Test
    public void testDecimalPredicatePushdown() throws Exception {
        try (AutoCloseable ignoreTable = this.withTable("test_decimal_pushdown", "(short_decimal decimal(9, 3), long_decimal decimal(30, 10))");){
            this.sqlServer.execute("INSERT INTO test_decimal_pushdown VALUES (123.321, 123456789.987654321)");
            this.assertQuery("SELECT * FROM test_decimal_pushdown WHERE short_decimal = 123.321", "VALUES (123.321, 123456789.987654321)");
            this.assertQuery("SELECT * FROM test_decimal_pushdown WHERE long_decimal = 123456789.987654321", "VALUES (123.321, 123456789.987654321)");
        }
    }

    private AutoCloseable withTable(String tableName, String tableDefinition) {
        this.sqlServer.execute(String.format("CREATE TABLE %s %s", tableName, tableDefinition));
        return () -> this.sqlServer.execute("DROP TABLE " + tableName);
    }
}

