/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.sqlserver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.prestosql.Session;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.plugin.sqlserver.SqlServerPlugin;
import io.prestosql.plugin.sqlserver.TestingSqlServer;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.security.Identity;
import io.prestosql.testing.DistributedQueryRunner;
import io.prestosql.testing.QueryAssertions;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingSession;
import io.prestosql.tpch.TpchTable;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class SqlServerQueryRunner {
    private static final String CATALOG = "sqlserver";
    private static final String TEST_SCHEMA = "dbo";

    private SqlServerQueryRunner() {
    }

    public static QueryRunner createSqlServerQueryRunner(TestingSqlServer testingSqlServer, TpchTable<?> ... tables) throws Exception {
        return SqlServerQueryRunner.createSqlServerQueryRunner(testingSqlServer, (Map<String, String>)ImmutableMap.of(), ImmutableList.copyOf((Object[])tables));
    }

    public static QueryRunner createSqlServerQueryRunner(TestingSqlServer testingSqlServer, Map<String, String> connectorProperties, Iterable<TpchTable<?>> tables) throws Exception {
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)SqlServerQueryRunner.createSession(testingSqlServer.getUsername())).build();
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch");
            connectorProperties = new HashMap<String, String>((Map<String, String>)ImmutableMap.copyOf(connectorProperties));
            connectorProperties.putIfAbsent("connection-url", testingSqlServer.getJdbcUrl());
            connectorProperties.putIfAbsent("connection-user", testingSqlServer.getUsername());
            connectorProperties.putIfAbsent("connection-password", testingSqlServer.getPassword());
            connectorProperties.putIfAbsent("allow-drop-table", "true");
            queryRunner.installPlugin((Plugin)new SqlServerPlugin());
            queryRunner.createCatalog(CATALOG, CATALOG, connectorProperties);
            SqlServerQueryRunner.provisionTables(SqlServerQueryRunner.createSession(testingSqlServer.getUsername()), (QueryRunner)queryRunner, tables);
            return queryRunner;
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (Closeable[])new Closeable[]{queryRunner});
            throw e;
        }
    }

    private static void provisionTables(Session session, QueryRunner queryRunner, Iterable<TpchTable<?>> tables) {
        Set existingTables = (Set)queryRunner.listTables(session, CATALOG, TEST_SCHEMA).stream().map(QualifiedObjectName::getObjectName).collect(ImmutableSet.toImmutableSet());
        Streams.stream(tables).filter(table -> !existingTables.contains(table.getTableName().toLowerCase(Locale.ENGLISH))).forEach(table -> QueryAssertions.copyTable((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (String)table.getTableName().toLowerCase(Locale.ENGLISH), (Session)session));
    }

    private static Session createSession(String username) {
        return TestingSession.testSessionBuilder().setCatalog(CATALOG).setSchema(TEST_SCHEMA).setIdentity(Identity.ofUser((String)username)).build();
    }

    public static void main(String[] args) throws Exception {
        Logging.initialize();
        TestingSqlServer testingSqlServer = new TestingSqlServer();
        testingSqlServer.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((TestingSqlServer)testingSqlServer).close()));
        DistributedQueryRunner queryRunner = (DistributedQueryRunner)SqlServerQueryRunner.createSqlServerQueryRunner(testingSqlServer, (Map<String, String>)ImmutableMap.of(), ImmutableList.of());
        Logger log = Logger.get(SqlServerQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }
}

