/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.sqlserver;

import com.google.common.base.Joiner;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import io.prestosql.plugin.jdbc.BaseJdbcClient;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.ColumnMapping;
import io.prestosql.plugin.jdbc.ConnectionFactory;
import io.prestosql.plugin.jdbc.DriverConnectionFactory;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcErrorCode;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.plugin.jdbc.JdbcTypeHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.type.Type;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.inject.Inject;

public class SqlServerClient
extends BaseJdbcClient {
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private static final int SQL_SERVER_MAX_LIST_EXPRESSIONS = 500;
    private static final UnaryOperator<Domain> DISABLE_UNSUPPORTED_PUSHDOWN = domain -> {
        if (domain.getValues().getRanges().getRangeCount() <= 500) {
            return domain;
        }
        return Domain.all((Type)domain.getType());
    };

    @Inject
    public SqlServerClient(BaseJdbcConfig config) {
        super(config, "\"", (ConnectionFactory)new DriverConnectionFactory((Driver)new SQLServerDriver(), config));
    }

    protected void renameTable(JdbcIdentity identity, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        String sql = String.format("sp_rename %s, %s", SqlServerClient.singleQuote(catalogName, schemaName, tableName), SqlServerClient.singleQuote(newTable.getTableName()));
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void renameColumn(JdbcIdentity identity, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            String sql = String.format("sp_rename %s, %s, 'COLUMN'", SqlServerClient.singleQuote(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName(), jdbcColumn.getColumnName()), SqlServerClient.singleQuote(newColumnName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public Optional<ColumnMapping> toPrestoType(ConnectorSession session, JdbcTypeHandle type) {
        return super.toPrestoType(session, type).map(columnMapping -> new ColumnMapping(columnMapping.getType(), columnMapping.getReadFunction(), columnMapping.getWriteFunction(), DISABLE_UNSUPPORTED_PUSHDOWN));
    }

    private static String singleQuote(String ... objects) {
        return SqlServerClient.singleQuote(DOT_JOINER.join((Object[])objects));
    }

    private static String singleQuote(String literal) {
        return "'" + literal + "'";
    }
}

