/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.descriptor;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.validation.metadata.CascadableDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ContainerDescriptor;
import javax.validation.metadata.ContainerElementTypeDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.GroupConversionDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.apache.bval.jsr.descriptor.CascadableContainerD;
import org.apache.bval.jsr.descriptor.ElementD;
import org.apache.bval.jsr.descriptor.Finder;
import org.apache.bval.jsr.descriptor.PropertyD;
import org.apache.bval.jsr.groups.GroupsComputer;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.util.Validate;

public abstract class ComposedD<D extends ElementD<?, ?>>
implements ElementDescriptor {
    protected final List<D> delegates;

    public static <T extends ElementD<?, ?>> Stream<T> unwrap(ElementDescriptor descriptor, Class<T> delegateType) {
        Stream<ElementDescriptor> s2 = descriptor instanceof ComposedD ? ((ComposedD)descriptor).delegates.stream().flatMap(d -> ComposedD.unwrap(d, delegateType)) : Stream.of(descriptor);
        return s2.map(delegateType::cast);
    }

    ComposedD(List<D> delegates) {
        this.delegates = delegates;
        Validate.notNull(delegates, "delegates", new Object[0]);
        Validate.isTrue(!delegates.isEmpty(), "At least one delegate is required", new Object[0]);
        Validate.isTrue(delegates.stream().noneMatch(Objects::isNull), "null delegates not permitted", new Object[0]);
    }

    @Override
    public boolean hasConstraints() {
        return this.delegates.stream().anyMatch(ElementDescriptor::hasConstraints);
    }

    @Override
    public Class<?> getElementClass() {
        return this.delegates.stream().map(ElementDescriptor::getElementClass).findFirst().orElseThrow(IllegalStateException::new);
    }

    @Override
    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return this.delegates.stream().map(ElementDescriptor::getConstraintDescriptors).flatMap(Collection::stream).collect(ToUnmodifiable.set());
    }

    @Override
    public ElementDescriptor.ConstraintFinder findConstraints() {
        GroupsComputer groupsComputer = ComposedD.unwrap((ElementDescriptor)this, ElementD.class).findFirst().orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/IllegalStateException;)()).groupsComputer;
        return new Finder(groupsComputer, this);
    }

    static class ForProperty
    extends ForCascadableContainer<PropertyD<?>>
    implements PropertyDescriptor {
        ForProperty(List<PropertyD<?>> delegates) {
            super(delegates);
        }

        @Override
        public String getPropertyName() {
            return this.delegates.stream().map(PropertyDescriptor::getPropertyName).findFirst().orElseThrow(IllegalStateException::new);
        }
    }

    static abstract class ForCascadableContainer<D extends CascadableContainerD<?, ?>>
    extends ComposedD<D>
    implements CascadableDescriptor,
    ContainerDescriptor {
        ForCascadableContainer(List<D> delegates) {
            super(delegates);
        }

        @Override
        public Set<ContainerElementTypeDescriptor> getConstrainedContainerElementTypes() {
            return this.delegates.stream().map(ContainerDescriptor::getConstrainedContainerElementTypes).flatMap(Collection::stream).collect(ToUnmodifiable.set());
        }

        @Override
        public boolean isCascaded() {
            return this.delegates.stream().anyMatch(CascadableDescriptor::isCascaded);
        }

        @Override
        public Set<GroupConversionDescriptor> getGroupConversions() {
            return this.delegates.stream().map(CascadableDescriptor::getGroupConversions).flatMap(Collection::stream).collect(ToUnmodifiable.set());
        }
    }
}

