/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class RenameSchema
extends Statement {
    private final QualifiedName source;
    private final Identifier target;

    public RenameSchema(QualifiedName source, Identifier target) {
        this(Optional.empty(), source, target);
    }

    public RenameSchema(NodeLocation location, QualifiedName source, Identifier target) {
        this(Optional.of(location), source, target);
    }

    private RenameSchema(Optional<NodeLocation> location, QualifiedName source, Identifier target) {
        super(location);
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
    }

    public QualifiedName getSource() {
        return this.source;
    }

    public Identifier getTarget() {
        return this.target;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRenameSchema(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.target);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RenameSchema o = (RenameSchema)obj;
        return Objects.equals(this.source, o.source) && Objects.equals(this.target, o.target);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("source", this.source).add("target", this.target).toString();
    }
}

