/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class RefreshMaterializedView
extends Statement {
    private final QualifiedName name;

    public RefreshMaterializedView(Optional<NodeLocation> location, QualifiedName name) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRefreshMaterializedView(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RefreshMaterializedView o = (RefreshMaterializedView)obj;
        return Objects.equals(this.name, o.name);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).toString();
    }
}

