/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.FetchFirst;
import io.prestosql.sql.tree.Limit;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Offset;
import io.prestosql.sql.tree.OrderBy;
import io.prestosql.sql.tree.QueryBody;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.With;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Query
extends Statement {
    private final Optional<With> with;
    private final QueryBody queryBody;
    private final Optional<OrderBy> orderBy;
    private final Optional<Offset> offset;
    private final Optional<Node> limit;

    public Query(Optional<With> with, QueryBody queryBody, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        this(Optional.empty(), with, queryBody, orderBy, offset, limit);
    }

    public Query(NodeLocation location, Optional<With> with, QueryBody queryBody, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        this(Optional.of(location), with, queryBody, orderBy, offset, limit);
    }

    private Query(Optional<NodeLocation> location, Optional<With> with, QueryBody queryBody, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        super(location);
        Objects.requireNonNull(with, "with is null");
        Objects.requireNonNull(queryBody, "queryBody is null");
        Objects.requireNonNull(orderBy, "orderBy is null");
        Objects.requireNonNull(offset, "offset is null");
        Objects.requireNonNull(limit, "limit is null");
        Preconditions.checkArgument(!limit.isPresent() || limit.get() instanceof FetchFirst || limit.get() instanceof Limit, "limit must be optional of either FetchFirst or Limit type");
        this.with = with;
        this.queryBody = queryBody;
        this.orderBy = orderBy;
        this.offset = offset;
        this.limit = limit;
    }

    public Optional<With> getWith() {
        return this.with;
    }

    public QueryBody getQueryBody() {
        return this.queryBody;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public Optional<Offset> getOffset() {
        return this.offset;
    }

    public Optional<Node> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuery(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.with.ifPresent(nodes::add);
        nodes.add(this.queryBody);
        this.orderBy.ifPresent(nodes::add);
        this.offset.ifPresent(nodes::add);
        this.limit.ifPresent(nodes::add);
        return nodes.build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("with", this.with.orElse(null)).add("queryBody", this.queryBody).add("orderBy", this.orderBy).add("offset", this.offset.orElse(null)).add("limit", this.limit.orElse(null)).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Query o = (Query)obj;
        return Objects.equals(this.with, o.with) && Objects.equals(this.queryBody, o.queryBody) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.offset, o.offset) && Objects.equals(this.limit, o.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.with, this.queryBody, this.orderBy, this.offset, this.limit);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return Query.sameClass(this, other);
    }
}

