/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IsNotNullPredicate
extends Expression {
    private final Expression value;

    public IsNotNullPredicate(Expression value) {
        this(Optional.empty(), value);
    }

    public IsNotNullPredicate(NodeLocation location, Expression value) {
        this(Optional.of(location), value);
    }

    private IsNotNullPredicate(Optional<NodeLocation> location, Expression value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        this.value = value;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIsNotNullPredicate(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsNotNullPredicate that = (IsNotNullPredicate)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return IsNotNullPredicate.sameClass(this, other);
    }
}

