/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Relation;
import io.prestosql.sql.tree.SetOperation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Intersect
extends SetOperation {
    private final List<Relation> relations;

    public Intersect(List<Relation> relations, boolean distinct) {
        this(Optional.empty(), relations, distinct);
    }

    public Intersect(NodeLocation location, List<Relation> relations, boolean distinct) {
        this(Optional.of(location), relations, distinct);
    }

    private Intersect(Optional<NodeLocation> location, List<Relation> relations, boolean distinct) {
        super(location, distinct);
        Objects.requireNonNull(relations, "relations is null");
        this.relations = ImmutableList.copyOf(relations);
    }

    @Override
    public List<Relation> getRelations() {
        return this.relations;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIntersect(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.relations;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("relations", this.relations).add("distinct", this.isDistinct()).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Intersect o = (Intersect)obj;
        return Objects.equals(this.relations, o.relations) && Objects.equals(this.isDistinct(), o.isDistinct());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.relations, this.isDistinct());
    }
}

