/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.DataType;
import io.prestosql.sql.tree.DataTypeParameter;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GenericDataType
extends DataType {
    private final Identifier name;
    private final List<DataTypeParameter> arguments;

    public GenericDataType(NodeLocation location, Identifier name, List<DataTypeParameter> arguments) {
        super(Optional.of(location));
        this.name = Objects.requireNonNull(name, "name is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public GenericDataType(Optional<NodeLocation> location, Identifier name, List<DataTypeParameter> arguments) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public List<DataTypeParameter> getArguments() {
        return this.arguments;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(this.name)).addAll(this.arguments)).build();
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGenericDataType(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericDataType that = (GenericDataType)o;
        return this.name.equals(that.name) && this.arguments.equals(that.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.arguments);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return GenericDataType.sameClass(this, other);
    }
}

