/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Parameter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FetchFirst
extends Node {
    private final Optional<Expression> rowCount;
    private final boolean withTies;

    public FetchFirst(Expression rowCount) {
        this(Optional.empty(), Optional.of(rowCount), false);
    }

    public FetchFirst(Expression rowCount, boolean withTies) {
        this(Optional.empty(), Optional.of(rowCount), withTies);
    }

    public FetchFirst(Optional<Expression> rowCount) {
        this(Optional.empty(), rowCount, false);
    }

    public FetchFirst(Optional<Expression> rowCount, boolean withTies) {
        this(Optional.empty(), rowCount, withTies);
    }

    public FetchFirst(Optional<NodeLocation> location, Optional<Expression> rowCount, boolean withTies) {
        super(location);
        rowCount.ifPresent(count -> Preconditions.checkArgument(count instanceof LongLiteral || count instanceof Parameter, "unexpected rowCount class: %s", (Object)rowCount.getClass().getSimpleName()));
        this.rowCount = rowCount;
        this.withTies = withTies;
    }

    public Optional<Expression> getRowCount() {
        return this.rowCount;
    }

    public boolean isWithTies() {
        return this.withTies;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFetchFirst(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.rowCount.map(ImmutableList::of).orElse(ImmutableList.of());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchFirst that = (FetchFirst)o;
        return this.withTies == that.withTies && Objects.equals(this.rowCount, that.rowCount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rowCount, this.withTies);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("rowCount", this.rowCount.orElse(null)).add("withTies", this.withTies).omitNullValues().toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!FetchFirst.sameClass(this, other)) {
            return false;
        }
        FetchFirst otherNode = (FetchFirst)other;
        return this.withTies == otherNode.withTies;
    }
}

