/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DropMaterializedView
extends Statement {
    private final QualifiedName name;
    private final boolean exists;

    public DropMaterializedView(QualifiedName name, boolean exists) {
        this(Optional.empty(), name, exists);
    }

    public DropMaterializedView(NodeLocation location, QualifiedName name, boolean exists) {
        this(Optional.of(location), name, exists);
    }

    private DropMaterializedView(Optional<NodeLocation> location, QualifiedName name, boolean exists) {
        super(location);
        this.name = name;
        this.exists = exists;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public boolean isExists() {
        return this.exists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropMaterializedView(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.exists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropMaterializedView o = (DropMaterializedView)obj;
        return Objects.equals(this.name, o.name) && this.exists == o.exists;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("exists", this.exists).toString();
    }
}

