/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.GroupingElement;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Cube
extends GroupingElement {
    private final List<Expression> columns;

    public Cube(List<Expression> columns) {
        this(Optional.empty(), columns);
    }

    public Cube(NodeLocation location, List<Expression> columns) {
        this(Optional.of(location), columns);
    }

    private Cube(Optional<NodeLocation> location, List<Expression> columns) {
        super(location);
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
    }

    @Override
    public List<Expression> getExpressions() {
        return this.columns;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCube(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cube cube = (Cube)o;
        return Objects.equals(this.columns, cube.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.columns);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("columns", this.columns).toString();
    }
}

