/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BetweenPredicate
extends Expression {
    private final Expression value;
    private final Expression min;
    private final Expression max;

    public BetweenPredicate(Expression value, Expression min2, Expression max) {
        this(Optional.empty(), value, min2, max);
    }

    public BetweenPredicate(NodeLocation location, Expression value, Expression min2, Expression max) {
        this(Optional.of(location), value, min2, max);
    }

    private BetweenPredicate(Optional<NodeLocation> location, Expression value, Expression min2, Expression max) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(min2, "min is null");
        Objects.requireNonNull(max, "max is null");
        this.value = value;
        this.min = min2;
        this.max = max;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getMin() {
        return this.min;
    }

    public Expression getMax() {
        return this.max;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBetweenPredicate(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.value, this.min, this.max);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetweenPredicate that = (BetweenPredicate)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.min, this.max);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return BetweenPredicate.sameClass(this, other);
    }
}

