/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StageStats {
    private final String stageId;
    private final String state;
    private final boolean done;
    private final int nodes;
    private final int totalSplits;
    private final int queuedSplits;
    private final int runningSplits;
    private final int completedSplits;
    private final long cpuTimeMillis;
    private final long wallTimeMillis;
    private final long processedRows;
    private final long processedBytes;
    private final long physicalInputBytes;
    private final List<StageStats> subStages;

    @JsonCreator
    public StageStats(@JsonProperty(value="stageId") String stageId, @JsonProperty(value="state") String state, @JsonProperty(value="done") boolean done, @JsonProperty(value="nodes") int nodes, @JsonProperty(value="totalSplits") int totalSplits, @JsonProperty(value="queuedSplits") int queuedSplits, @JsonProperty(value="runningSplits") int runningSplits, @JsonProperty(value="completedSplits") int completedSplits, @JsonProperty(value="cpuTimeMillis") long cpuTimeMillis, @JsonProperty(value="wallTimeMillis") long wallTimeMillis, @JsonProperty(value="processedRows") long processedRows, @JsonProperty(value="processedBytes") long processedBytes, @JsonProperty(value="physicalInputBytes") long physicalInputBytes, @JsonProperty(value="subStages") List<StageStats> subStages) {
        this.stageId = stageId;
        this.state = Objects.requireNonNull(state, "state is null");
        this.done = done;
        this.nodes = nodes;
        this.totalSplits = totalSplits;
        this.queuedSplits = queuedSplits;
        this.runningSplits = runningSplits;
        this.completedSplits = completedSplits;
        this.cpuTimeMillis = cpuTimeMillis;
        this.wallTimeMillis = wallTimeMillis;
        this.processedRows = processedRows;
        this.processedBytes = processedBytes;
        this.physicalInputBytes = physicalInputBytes;
        this.subStages = ImmutableList.copyOf((Collection)Objects.requireNonNull(subStages, "subStages is null"));
    }

    @JsonProperty
    public String getStageId() {
        return this.stageId;
    }

    @JsonProperty
    public String getState() {
        return this.state;
    }

    @JsonProperty
    public boolean isDone() {
        return this.done;
    }

    @JsonProperty
    public int getNodes() {
        return this.nodes;
    }

    @JsonProperty
    public int getTotalSplits() {
        return this.totalSplits;
    }

    @JsonProperty
    public int getQueuedSplits() {
        return this.queuedSplits;
    }

    @JsonProperty
    public int getRunningSplits() {
        return this.runningSplits;
    }

    @JsonProperty
    public int getCompletedSplits() {
        return this.completedSplits;
    }

    @JsonProperty
    public long getCpuTimeMillis() {
        return this.cpuTimeMillis;
    }

    @JsonProperty
    public long getWallTimeMillis() {
        return this.wallTimeMillis;
    }

    @JsonProperty
    public long getProcessedRows() {
        return this.processedRows;
    }

    @JsonProperty
    public long getProcessedBytes() {
        return this.processedBytes;
    }

    @JsonProperty
    public long getPhysicalInputBytes() {
        return this.physicalInputBytes;
    }

    @JsonProperty
    public List<StageStats> getSubStages() {
        return this.subStages;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("state", this.state).add("done", this.done).add("nodes", this.nodes).add("totalSplits", this.totalSplits).add("queuedSplits", this.queuedSplits).add("runningSplits", this.runningSplits).add("completedSplits", this.completedSplits).add("cpuTimeMillis", this.cpuTimeMillis).add("wallTimeMillis", this.wallTimeMillis).add("processedRows", this.processedRows).add("processedBytes", this.processedBytes).add("physicalInputBytes", this.physicalInputBytes).add("subStages", this.subStages).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String stageId;
        private String state;
        private boolean done;
        private int nodes;
        private int totalSplits;
        private int queuedSplits;
        private int runningSplits;
        private int completedSplits;
        private long cpuTimeMillis;
        private long wallTimeMillis;
        private long processedRows;
        private long processedBytes;
        private long physicalInputBytes;
        private List<StageStats> subStages;

        private Builder() {
        }

        public Builder setStageId(String stageId) {
            this.stageId = Objects.requireNonNull(stageId, "stageId is null");
            return this;
        }

        public Builder setState(String state) {
            this.state = Objects.requireNonNull(state, "state is null");
            return this;
        }

        public Builder setDone(boolean done) {
            this.done = done;
            return this;
        }

        public Builder setNodes(int nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder setTotalSplits(int totalSplits) {
            this.totalSplits = totalSplits;
            return this;
        }

        public Builder setQueuedSplits(int queuedSplits) {
            this.queuedSplits = queuedSplits;
            return this;
        }

        public Builder setRunningSplits(int runningSplits) {
            this.runningSplits = runningSplits;
            return this;
        }

        public Builder setCompletedSplits(int completedSplits) {
            this.completedSplits = completedSplits;
            return this;
        }

        public Builder setCpuTimeMillis(long cpuTimeMillis) {
            this.cpuTimeMillis = cpuTimeMillis;
            return this;
        }

        public Builder setWallTimeMillis(long wallTimeMillis) {
            this.wallTimeMillis = wallTimeMillis;
            return this;
        }

        public Builder setProcessedRows(long processedRows) {
            this.processedRows = processedRows;
            return this;
        }

        public Builder setProcessedBytes(long processedBytes) {
            this.processedBytes = processedBytes;
            return this;
        }

        public Builder setPhysicalInputBytes(long physicalInputBytes) {
            this.physicalInputBytes = physicalInputBytes;
            return this;
        }

        public Builder setSubStages(List<StageStats> subStages) {
            this.subStages = ImmutableList.copyOf((Collection)Objects.requireNonNull(subStages, "subStages is null"));
            return this;
        }

        public StageStats build() {
            return new StageStats(this.stageId, this.state, this.done, this.nodes, this.totalSplits, this.queuedSplits, this.runningSplits, this.completedSplits, this.cpuTimeMillis, this.wallTimeMillis, this.processedRows, this.processedBytes, this.physicalInputBytes, this.subStages);
        }
    }
}

