/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import com.google.common.base.MoreObjects;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.prestosql.cli.ClientOptions;
import io.prestosql.cli.Console;
import picocli.CommandLine;

public final class Presto {
    private Presto() {
    }

    public static void main(String[] args) {
        System.exit(Presto.createCommandLine(new Console()).execute(args));
    }

    public static CommandLine createCommandLine(Object command) {
        return new CommandLine(command).registerConverter(ClientOptions.ClientResourceEstimate.class, ClientOptions.ClientResourceEstimate::new).registerConverter(ClientOptions.ClientSessionProperty.class, ClientOptions.ClientSessionProperty::new).registerConverter(ClientOptions.ClientExtraCredential.class, ClientOptions.ClientExtraCredential::new).registerConverter(HostAndPort.class, HostAndPort::fromString).registerConverter(Duration.class, Duration::valueOf);
    }

    public static class VersionProvider
    implements CommandLine.IVersionProvider {
        @Override
        public String[] getVersion() {
            String version = this.getClass().getPackage().getImplementationVersion();
            return new String[]{"Presto CLI " + MoreObjects.firstNonNull(version, "(version unknown)")};
        }
    }
}

