/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import io.prestosql.cli.TerminalUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class ConsolePrinter {
    private static final String ERASE_SCREEN_FORWARD = "\u001b[0J";
    private static final String ERASE_LINE_ALL = "\u001b[2K";
    private final PrintStream out;
    private int lines;

    public ConsolePrinter(PrintStream out) {
        this.out = Objects.requireNonNull(out, "out is null");
    }

    public void reprintLine(String line) {
        if (TerminalUtils.isRealTerminal()) {
            this.out.print(ERASE_LINE_ALL + line + "\n");
        } else {
            this.out.print('\r' + line);
        }
        this.out.flush();
        ++this.lines;
    }

    public void repositionCursor() {
        if (this.lines > 0) {
            if (TerminalUtils.isRealTerminal()) {
                this.out.print(ConsolePrinter.cursorUp(this.lines));
            } else {
                this.out.print('\r');
            }
            this.out.flush();
            this.lines = 0;
        }
    }

    public void resetScreen() {
        if (this.lines > 0) {
            if (TerminalUtils.isRealTerminal()) {
                this.out.print(ConsolePrinter.cursorUp(this.lines) + ERASE_SCREEN_FORWARD);
            } else {
                this.out.print('\r');
            }
            this.out.flush();
            this.lines = 0;
        }
    }

    public int getWidth() {
        int n;
        block8: {
            Terminal terminal = TerminalBuilder.terminal();
            try {
                n = terminal.getWidth();
                if (terminal == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (terminal != null) {
                        try {
                            terminal.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            terminal.close();
        }
        return n;
    }

    private static String cursorUp(int lines) {
        return "\u001b[" + lines + "A";
    }
}

