/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.prestosql.client.ClientSession;
import io.prestosql.client.KerberosUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import picocli.CommandLine;

public class ClientOptions {
    private static final Splitter NAME_VALUE_SPLITTER = Splitter.on('=').limit(2);
    private static final CharMatcher PRINTABLE_ASCII = CharMatcher.inRange('!', '~');
    private static final String DEFAULT_VALUE = "(default: ${DEFAULT-VALUE})";
    @CommandLine.Option(names={"--server"}, paramLabel="<server>", defaultValue="localhost:8080", description={"Presto server location (default: ${DEFAULT-VALUE})"})
    public String server;
    @CommandLine.Option(names={"--krb5-service-principal-pattern"}, paramLabel="<pattern>", defaultValue="$${SERVICE}@$${HOST}", description={"Remote kerberos service principal pattern (default: ${DEFAULT-VALUE})"})
    public String krb5ServicePrincipalPattern;
    @CommandLine.Option(names={"--krb5-remote-service-name"}, paramLabel="<name>", description={"Remote peer's kerberos service name"})
    public String krb5RemoteServiceName;
    @CommandLine.Option(names={"--krb5-config-path"}, paramLabel="<path>", defaultValue="/etc/krb5.conf", description={"Kerberos config file path (default: ${DEFAULT-VALUE})"})
    public String krb5ConfigPath;
    @CommandLine.Option(names={"--krb5-keytab-path"}, paramLabel="<path>", defaultValue="/etc/krb5.keytab", description={"Kerberos key table path (default: ${DEFAULT-VALUE})"})
    public String krb5KeytabPath;
    @CommandLine.Option(names={"--krb5-credential-cache-path"}, paramLabel="<path>", description={"Kerberos credential cache path"})
    public String krb5CredentialCachePath = KerberosUtil.defaultCredentialCachePath().orElse(null);
    @CommandLine.Option(names={"--krb5-principal"}, paramLabel="<principal>", description={"Kerberos principal to be used"})
    public String krb5Principal;
    @CommandLine.Option(names={"--krb5-disable-remote-service-hostname-canonicalization"}, description={"Disable service hostname canonicalization using the DNS reverse lookup"})
    public boolean krb5DisableRemoteServiceHostnameCanonicalization;
    @CommandLine.Option(names={"--keystore-path"}, paramLabel="<path>", description={"Keystore path"})
    public String keystorePath;
    @CommandLine.Option(names={"--keystore-password"}, paramLabel="<password>", description={"Keystore password"})
    public String keystorePassword;
    @CommandLine.Option(names={"--keystore-type"}, paramLabel="<type>", description={"Keystore type"})
    public String keystoreType;
    @CommandLine.Option(names={"--truststore-path"}, paramLabel="<path>", description={"Truststore path"})
    public String truststorePath;
    @CommandLine.Option(names={"--truststore-password"}, paramLabel="<password>", description={"Truststore password"})
    public String truststorePassword;
    @CommandLine.Option(names={"--truststore-type"}, paramLabel="<type>", description={"Truststore type"})
    public String truststoreType;
    @CommandLine.Option(names={"--insecure"}, description={"Skip validation of HTTP server certificates (should only be used for debugging)"})
    public boolean insecure;
    @CommandLine.Option(names={"--access-token"}, paramLabel="<token>", description={"Access token"})
    public String accessToken;
    @CommandLine.Option(names={"--user"}, paramLabel="<user>", description={"Username (default: ${DEFAULT-VALUE})"})
    public String user = System.getProperty("user.name");
    @CommandLine.Option(names={"--password"}, paramLabel="<password>", description={"Prompt for password"})
    public boolean password;
    @CommandLine.Option(names={"--source"}, paramLabel="<source>", defaultValue="presto-cli", description={"Name of source making query (default: ${DEFAULT-VALUE})"})
    public String source;
    @CommandLine.Option(names={"--client-info"}, paramLabel="<info>", description={"Extra information about client making query"})
    public String clientInfo;
    @CommandLine.Option(names={"--client-tags"}, paramLabel="<tags>", description={"Client tags"})
    public String clientTags;
    @CommandLine.Option(names={"--trace-token"}, paramLabel="<token>", description={"Trace token"})
    public String traceToken;
    @CommandLine.Option(names={"--catalog"}, paramLabel="<catalog>", description={"Default catalog"})
    public String catalog;
    @CommandLine.Option(names={"--schema"}, paramLabel="<schema>", description={"Default schema"})
    public String schema;
    @CommandLine.Option(names={"-f", "--file"}, paramLabel="<file>", description={"Execute statements from file and exit"})
    public String file;
    @CommandLine.Option(names={"--debug"}, paramLabel="<debug>", description={"Enable debug information"})
    public boolean debug;
    @CommandLine.Option(names={"--progress"}, paramLabel="<progress>", description={"Show query progress in batch mode"})
    public boolean progress;
    @CommandLine.Option(names={"--log-levels-file"}, paramLabel="<file>", description={"Configure log levels for debugging using this file"})
    public String logLevelsFile;
    @CommandLine.Option(names={"--execute"}, paramLabel="<execute>", description={"Execute specified statements and exit"})
    public String execute;
    @CommandLine.Option(names={"--output-format"}, paramLabel="<format>", defaultValue="CSV", description={"Output format for batch mode [${COMPLETION-CANDIDATES}] (default: ${DEFAULT-VALUE})"})
    public OutputFormat outputFormat;
    @CommandLine.Option(names={"--resource-estimate"}, paramLabel="<estimate>", description={"Resource estimate (property can be used multiple times; format is key=value)"})
    public final List<ClientResourceEstimate> resourceEstimates = new ArrayList<ClientResourceEstimate>();
    @CommandLine.Option(names={"--session"}, paramLabel="<session>", description={"Session property (property can be used multiple times; format is key=value; use 'SHOW SESSION' to see available properties)"})
    public final List<ClientSessionProperty> sessionProperties = new ArrayList<ClientSessionProperty>();
    @CommandLine.Option(names={"--extra-credential"}, paramLabel="<credential>", description={"Extra credentials (property can be used multiple times; format is key=value)"})
    public final List<ClientExtraCredential> extraCredentials = new ArrayList<ClientExtraCredential>();
    @CommandLine.Option(names={"--socks-proxy"}, paramLabel="<proxy>", description={"SOCKS proxy to use for server connections"})
    public HostAndPort socksProxy;
    @CommandLine.Option(names={"--http-proxy"}, paramLabel="<proxy>", description={"HTTP proxy to use for server connections"})
    public HostAndPort httpProxy;
    @CommandLine.Option(names={"--client-request-timeout"}, paramLabel="<timeout>", defaultValue="2m", description={"Client request timeout (default: ${DEFAULT-VALUE})"})
    public Duration clientRequestTimeout;
    @CommandLine.Option(names={"--ignore-errors"}, description={"Continue processing in batch mode when an error occurs (default is to exit immediately)"})
    public boolean ignoreErrors;
    @CommandLine.Option(names={"--timezone"}, paramLabel="<timezone>", description={"Session time zone (default: ${DEFAULT-VALUE})"})
    public ZoneId timeZone = ZoneId.systemDefault();
    @CommandLine.Option(names={"--disable-compression"}, description={"Disable compression of query results"})
    public boolean disableCompression;

    public ClientSession toClientSession() {
        return new ClientSession(ClientOptions.parseServer(this.server), this.user, this.source, Optional.ofNullable(this.traceToken), ClientOptions.parseClientTags(Strings.nullToEmpty(this.clientTags)), this.clientInfo, this.catalog, this.schema, null, this.timeZone, Locale.getDefault(), ClientOptions.toResourceEstimates(this.resourceEstimates), ClientOptions.toProperties(this.sessionProperties), Collections.emptyMap(), Collections.emptyMap(), ClientOptions.toExtraCredentials(this.extraCredentials), null, this.clientRequestTimeout, this.disableCompression);
    }

    public static URI parseServer(String server) {
        if ((server = server.toLowerCase(Locale.ENGLISH)).startsWith("http://") || server.startsWith("https://")) {
            return URI.create(server);
        }
        HostAndPort host = HostAndPort.fromString(server);
        try {
            return new URI("http", null, host.getHost(), host.getPortOrDefault(80), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Set<String> parseClientTags(String clientTagsString) {
        Splitter splitter = Splitter.on(',').trimResults().omitEmptyStrings();
        return ImmutableSet.copyOf(splitter.split(Strings.nullToEmpty(clientTagsString)));
    }

    public static Map<String, String> toProperties(List<ClientSessionProperty> sessionProperties) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (ClientSessionProperty sessionProperty : sessionProperties) {
            String name = sessionProperty.getName();
            if (sessionProperty.getCatalog().isPresent()) {
                name = sessionProperty.getCatalog().get() + "." + name;
            }
            builder.put(name, sessionProperty.getValue());
        }
        return builder.build();
    }

    public static Map<String, String> toResourceEstimates(List<ClientResourceEstimate> estimates) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (ClientResourceEstimate estimate : estimates) {
            builder.put(estimate.getResource(), estimate.getEstimate());
        }
        return builder.build();
    }

    public static Map<String, String> toExtraCredentials(List<ClientExtraCredential> extraCredentials) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (ClientExtraCredential credential : extraCredentials) {
            builder.put(credential.getName(), credential.getValue());
        }
        return builder.build();
    }

    public static final class ClientExtraCredential {
        private final String name;
        private final String value;

        public ClientExtraCredential(String extraCredential) {
            List<String> nameValue = NAME_VALUE_SPLITTER.splitToList(extraCredential);
            Preconditions.checkArgument(nameValue.size() == 2, "Extra credential: %s", (Object)extraCredential);
            this.name = nameValue.get(0);
            this.value = nameValue.get(1);
            Preconditions.checkArgument(!this.name.isEmpty(), "Credential name is empty");
            Preconditions.checkArgument(!this.value.isEmpty(), "Credential value is empty");
            Preconditions.checkArgument(PRINTABLE_ASCII.matchesAllOf(this.name), "Credential name contains spaces or is not ASCII: %s", (Object)this.name);
            Preconditions.checkArgument(this.name.indexOf(61) < 0, "Credential name must not contain '=': %s", (Object)this.name);
            Preconditions.checkArgument(PRINTABLE_ASCII.matchesAllOf(this.value), "Credential value contains space or is not ASCII: %s", (Object)this.name);
        }

        public ClientExtraCredential(String name, String value) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + '=' + this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientExtraCredential other = (ClientExtraCredential)o;
            return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }
    }

    public static final class ClientSessionProperty {
        private static final Splitter NAME_SPLITTER = Splitter.on('.');
        private final Optional<String> catalog;
        private final String name;
        private final String value;

        public ClientSessionProperty(String property) {
            List<String> nameValue = NAME_VALUE_SPLITTER.splitToList(property);
            Preconditions.checkArgument(nameValue.size() == 2, "Session property: %s", (Object)property);
            List<String> nameParts = NAME_SPLITTER.splitToList(nameValue.get(0));
            Preconditions.checkArgument(nameParts.size() == 1 || nameParts.size() == 2, "Invalid session property: %s", (Object)property);
            if (nameParts.size() == 1) {
                this.catalog = Optional.empty();
                this.name = nameParts.get(0);
            } else {
                this.catalog = Optional.of(nameParts.get(0));
                this.name = nameParts.get(1);
            }
            this.value = nameValue.get(1);
            ClientSessionProperty.verifyProperty(this.catalog, this.name, this.value);
        }

        public ClientSessionProperty(Optional<String> catalog, String name, String value) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            this.name = Objects.requireNonNull(name, "name is null");
            this.value = Objects.requireNonNull(value, "value is null");
            ClientSessionProperty.verifyProperty(catalog, name, value);
        }

        private static void verifyProperty(Optional<String> catalog, String name, String value) {
            Preconditions.checkArgument(!catalog.isPresent() || !catalog.get().isEmpty(), "Invalid session property: %s.%s:%s", catalog, (Object)name, (Object)value);
            Preconditions.checkArgument(!name.isEmpty(), "Session property name is empty");
            Preconditions.checkArgument(catalog.orElse("").indexOf(61) < 0, "Session property catalog must not contain '=': %s", (Object)name);
            Preconditions.checkArgument(PRINTABLE_ASCII.matchesAllOf(catalog.orElse("")), "Session property catalog contains spaces or is not ASCII: %s", (Object)name);
            Preconditions.checkArgument(name.indexOf(61) < 0, "Session property name must not contain '=': %s", (Object)name);
            Preconditions.checkArgument(PRINTABLE_ASCII.matchesAllOf(name), "Session property name contains spaces or is not ASCII: %s", (Object)name);
            Preconditions.checkArgument(PRINTABLE_ASCII.matchesAllOf(value), "Session property value contains spaces or is not ASCII: %s", (Object)value);
        }

        public Optional<String> getCatalog() {
            return this.catalog;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return (this.catalog.isPresent() ? this.catalog.get() + '.' : "") + this.name + '=' + this.value;
        }

        public int hashCode() {
            return Objects.hash(this.catalog, this.name, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ClientSessionProperty other = (ClientSessionProperty)obj;
            return Objects.equals(this.catalog, other.catalog) && Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
        }
    }

    public static final class ClientResourceEstimate {
        private final String resource;
        private final String estimate;

        public ClientResourceEstimate(String resourceEstimate) {
            List<String> nameValue = NAME_VALUE_SPLITTER.splitToList(resourceEstimate);
            Preconditions.checkArgument(nameValue.size() == 2, "Resource estimate: %s", (Object)resourceEstimate);
            this.resource = nameValue.get(0);
            this.estimate = nameValue.get(1);
            Preconditions.checkArgument(!this.resource.isEmpty(), "Resource name is empty");
            Preconditions.checkArgument(!this.estimate.isEmpty(), "Resource estimate is empty");
            Preconditions.checkArgument(PRINTABLE_ASCII.matchesAllOf(this.resource), "Resource contains spaces or is not ASCII: %s", (Object)this.resource);
            Preconditions.checkArgument(this.resource.indexOf(61) < 0, "Resource must not contain '=': %s", (Object)this.resource);
            Preconditions.checkArgument(PRINTABLE_ASCII.matchesAllOf(this.estimate), "Resource estimate contains spaces or is not ASCII: %s", (Object)this.resource);
        }

        @VisibleForTesting
        public ClientResourceEstimate(String resource, String estimate) {
            this.resource = Objects.requireNonNull(resource, "resource is null");
            this.estimate = estimate;
        }

        public String getResource() {
            return this.resource;
        }

        public String getEstimate() {
            return this.estimate;
        }

        public String toString() {
            return this.resource + '=' + this.estimate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientResourceEstimate other = (ClientResourceEstimate)o;
            return Objects.equals(this.resource, other.resource) && Objects.equals(this.estimate, other.estimate);
        }

        public int hashCode() {
            return Objects.hash(this.resource, this.estimate);
        }
    }

    public static enum OutputFormat {
        ALIGNED,
        VERTICAL,
        TSV,
        TSV_HEADER,
        CSV,
        CSV_HEADER,
        CSV_UNQUOTED,
        CSV_HEADER_UNQUOTED,
        JSON,
        NULL;

    }
}

