/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import io.prestosql.cli.OutputPrinter;
import io.prestosql.client.Column;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jline.utils.AttributedString;
import org.jline.utils.WCWidth;

public class AlignedTablePrinter
implements OutputPrinter {
    private static final Set<String> NUMERIC_TYPES = ImmutableSet.of("tinyint", "smallint", "integer", "bigint", "real", "double", new String[]{"decimal"});
    private static final Splitter LINE_SPLITTER = Splitter.on('\n');
    private static final Splitter HEX_SPLITTER = Splitter.fixedLength(2);
    private static final Joiner HEX_BYTE_JOINER = Joiner.on(' ');
    private static final Joiner HEX_LINE_JOINER = Joiner.on('\n');
    private final List<String> fieldNames;
    private final List<Boolean> numericFields;
    private final Writer writer;
    private boolean headerOutput;
    private long rowCount;

    public AlignedTablePrinter(List<Column> columns, Writer writer) {
        Objects.requireNonNull(columns, "columns is null");
        this.fieldNames = columns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        this.numericFields = columns.stream().map(Column::getTypeSignature).map(signature -> NUMERIC_TYPES.contains(signature.getRawType())).collect(ImmutableList.toImmutableList());
        this.writer = Objects.requireNonNull(writer, "writer is null");
    }

    @Override
    public void finish() throws IOException {
        this.printRows(ImmutableList.of(), true);
        this.writer.append(String.format("(%s row%s)%n", this.rowCount, this.rowCount != 1L ? "s" : ""));
        this.writer.flush();
    }

    @Override
    public void printRows(List<List<?>> rows, boolean complete) throws IOException {
        this.rowCount += (long)rows.size();
        int columns = this.fieldNames.size();
        int[] maxWidth = new int[columns];
        for (int i = 0; i < columns; ++i) {
            maxWidth[i] = Math.max(1, AlignedTablePrinter.consoleWidth(this.fieldNames.get(i)));
        }
        for (List<?> row : rows) {
            for (int i = 0; i < row.size(); ++i) {
                String s2 = AlignedTablePrinter.formatValue(row.get(i));
                maxWidth[i] = Math.max(maxWidth[i], AlignedTablePrinter.maxLineLength(s2));
            }
        }
        if (!this.headerOutput) {
            int i;
            this.headerOutput = true;
            for (i = 0; i < columns; ++i) {
                if (i > 0) {
                    this.writer.append('|');
                }
                String name = this.fieldNames.get(i);
                this.writer.append(AlignedTablePrinter.center(name, maxWidth[i], 1));
            }
            this.writer.append('\n');
            for (i = 0; i < columns; ++i) {
                if (i > 0) {
                    this.writer.append('+');
                }
                this.writer.append(Strings.repeat("-", maxWidth[i] + 2));
            }
            this.writer.append('\n');
        }
        for (List<?> row : rows) {
            List<String> lines;
            ArrayList<ImmutableList<String>> columnLines = new ArrayList<ImmutableList<String>>(columns);
            int maxLines = 1;
            for (int i = 0; i < columns; ++i) {
                String s3 = AlignedTablePrinter.formatValue(row.get(i));
                lines = ImmutableList.copyOf(LINE_SPLITTER.split(s3));
                columnLines.add((ImmutableList<String>)lines);
                maxLines = Math.max(maxLines, ((AbstractCollection)((Object)lines)).size());
            }
            for (int line = 0; line < maxLines; ++line) {
                for (int column = 0; column < columns; ++column) {
                    if (column > 0) {
                        this.writer.append('|');
                    }
                    String s4 = line < (lines = (List)columnLines.get(column)).size() ? lines.get(line) : "";
                    boolean numeric = this.numericFields.get(column);
                    String out = AlignedTablePrinter.align(s4, maxWidth[column], 1, numeric);
                    if (!(complete && this.rowCount <= 1L || line + 1 >= lines.size())) {
                        out = out.substring(0, out.length() - 1) + "+";
                    }
                    this.writer.append(out);
                }
                this.writer.append('\n');
            }
        }
        this.writer.flush();
    }

    static String formatValue(Object o) {
        if (o == null) {
            return "NULL";
        }
        if (o instanceof Map) {
            return AlignedTablePrinter.formatMap((Map)o);
        }
        if (o instanceof List) {
            return AlignedTablePrinter.formatList((List)o);
        }
        if (o instanceof byte[]) {
            return AlignedTablePrinter.formatHexDump((byte[])o, 16);
        }
        return o.toString();
    }

    private static String formatHexDump(byte[] bytes, int bytesPerLine) {
        Iterable<String> hexPairs = AlignedTablePrinter.createHexPairs(bytes);
        Iterable<List<String>> hexLines = Iterables.partition(hexPairs, bytesPerLine);
        Iterable lines = Iterables.transform(hexLines, HEX_BYTE_JOINER::join);
        return HEX_LINE_JOINER.join(lines);
    }

    static String formatHexDump(byte[] bytes) {
        return HEX_BYTE_JOINER.join(AlignedTablePrinter.createHexPairs(bytes));
    }

    private static Iterable<String> createHexPairs(byte[] bytes) {
        String hexDump = BaseEncoding.base16().lowerCase().encode(bytes);
        return HEX_SPLITTER.split(hexDump);
    }

    static String formatList(List<? extends Object> list) {
        return list.stream().map(AlignedTablePrinter::formatValue).collect(Collectors.joining(", ", "[", "]"));
    }

    static String formatMap(Map<? extends Object, ? extends Object> map) {
        return map.entrySet().stream().map(entry -> String.format("%s=%s", AlignedTablePrinter.formatValue(entry.getKey()), AlignedTablePrinter.formatValue(entry.getValue()))).collect(Collectors.joining(", ", "{", "}"));
    }

    private static String center(String s2, int maxWidth, int padding) {
        int width = AlignedTablePrinter.consoleWidth(s2);
        Preconditions.checkState(width <= maxWidth, "string width is greater than max width");
        int left = (maxWidth - width) / 2;
        int right = maxWidth - (left + width);
        return Strings.repeat(" ", left + padding) + s2 + Strings.repeat(" ", right + padding);
    }

    private static String align(String s2, int maxWidth, int padding, boolean right) {
        int width = AlignedTablePrinter.consoleWidth(s2);
        Preconditions.checkState(width <= maxWidth, "string width is greater than max width");
        String large = Strings.repeat(" ", maxWidth - width + padding);
        String small = Strings.repeat(" ", padding);
        return right ? large + s2 + small : small + s2 + large;
    }

    static int maxLineLength(String s2) {
        int n = 0;
        for (String line : LINE_SPLITTER.split(s2)) {
            n = Math.max(n, AlignedTablePrinter.consoleWidth(line));
        }
        return n;
    }

    static int consoleWidth(String s2) {
        String plain = AttributedString.stripAnsi(s2);
        int n = 0;
        for (int i = 0; i < plain.length(); ++i) {
            n += Math.max(WCWidth.wcwidth(plain.charAt(i)), 0);
        }
        return n;
    }
}

